/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.security.provider;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.xml.XMLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSecurityPolicy<RequestType extends ServletRequest>
implements SecurityPolicy<RequestType> {
    private boolean requireAuthenticatedIssuer;
    private String issuer;
    private Boolean issuerAuthenticated;
    private SecurityPolicyContext policyContext;
    private List<SecurityPolicyRule<RequestType>> securityRules;

    public BasicSecurityPolicy() {
        this.requireAuthenticatedIssuer = true;
        this.securityRules = new ArrayList<SecurityPolicyRule<RequestType>>();
        this.policyContext = this.createNewContext();
    }

    public BasicSecurityPolicy(boolean authenticatedIssuer) {
        this.requireAuthenticatedIssuer = authenticatedIssuer;
        this.securityRules = new ArrayList<SecurityPolicyRule<RequestType>>();
    }

    @Override
    public SecurityPolicyContext getSecurityPolicyContext() {
        return this.policyContext;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public Boolean isIssuerAuthenticated() {
        return this.issuerAuthenticated;
    }

    @Override
    public List<SecurityPolicyRule<RequestType>> getPolicyRules() {
        return this.securityRules;
    }

    @Override
    public void evaluate(RequestType request, XMLObject message) throws SecurityPolicyException {
        this.policyContext = this.createNewContext();
        ArrayList<Boolean> issuerAuthenticationTracker = new ArrayList<Boolean>(this.securityRules.size());
        for (SecurityPolicyRule<RequestType> rule : this.securityRules) {
            rule.evaluate(request, message, this.policyContext);
            issuerAuthenticationTracker.add(this.policyContext.isIssuerAuthenticated());
            if (this.issuer != null && this.policyContext.getIssuer() != null && !this.issuer.equals(this.policyContext.getIssuer())) {
                throw new SecurityPolicyException("Policy rules presented two or more, different, issuer IDs");
            }
            this.issuer = this.policyContext.getIssuer();
        }
        this.issuerAuthenticated = issuerAuthenticationTracker.contains(Boolean.FALSE) ? Boolean.FALSE : (issuerAuthenticationTracker.contains(Boolean.TRUE) ? Boolean.TRUE : null);
        if (this.requireAuthenticatedIssuer && this.issuerAuthenticated != Boolean.TRUE) {
            throw new SecurityPolicyException("Issuer was not authenticated by security policy rules.");
        }
    }

    protected SecurityPolicyContext createNewContext() {
        return new SecurityPolicyContext();
    }
}

