/*
 * Copyright (c) 2002-2006 by OpenSymphony
 * All rights reserved.
 */
package com.opensymphony.xwork.apt;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;

/**
 * <code>Generator</code>
 *
 * @author Rainer Hermanns
 * @version $Id: Generator.java 860 2006-03-03 16:10:09 +0100 (Fri, 03 Mar 2006) rainerh $
 */
public abstract class Generator {


    protected AnnotationProcessorEnvironment env;


    /**
     * Sets the AnnotationProcessorEnvironment.
     *
     * @param env the AnnotationProcessorEnvironment.
     */
    public void setEnv(AnnotationProcessorEnvironment env) {
        this.env = env;
    }

    /**
     * Generate the configuration file.
     * Concrete implementations must override this method.
     */
    public abstract void generate(Filer filer);

}
