/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.xwork.ActionChainResult;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.NonCloningContinuableObject;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.XworkException;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.InterceptorMapping;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.uwyn.rife.continuations.ContinuableObject;
import com.uwyn.rife.continuations.ContinuationConfig;
import com.uwyn.rife.continuations.ContinuationContext;
import com.uwyn.rife.continuations.ContinuationManager;
import com.uwyn.rife.continuations.exceptions.PauseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultActionInvocation
implements ActionInvocation {
    public static ContinuationManager m;
    private static final Log LOG;
    protected Object action;
    protected ActionProxy proxy;
    protected List preResultListeners;
    protected Map extraContext;
    protected ActionContext invocationContext;
    protected Iterator interceptors;
    protected OgnlValueStack stack;
    protected Result result;
    protected String resultCode;
    protected boolean executed = false;
    protected boolean pushAction = true;
    static /* synthetic */ Class class$com$opensymphony$xwork$DefaultActionInvocation;

    protected DefaultActionInvocation(ActionProxy proxy) throws Exception {
        this(proxy, null);
    }

    protected DefaultActionInvocation(ActionProxy proxy, Map extraContext) throws Exception {
        this(proxy, extraContext, true);
    }

    protected DefaultActionInvocation(ActionProxy proxy, Map extraContext, boolean pushAction) throws Exception {
        this.proxy = proxy;
        this.extraContext = extraContext;
        this.pushAction = pushAction;
        this.init();
    }

    public Object getAction() {
        return this.action;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public ActionContext getInvocationContext() {
        return this.invocationContext;
    }

    public ActionProxy getProxy() {
        return this.proxy;
    }

    public Result getResult() throws Exception {
        Result proxyResult;
        ActionProxy aProxy;
        Result returnResult = this.result;
        while (returnResult instanceof ActionChainResult && (aProxy = ((ActionChainResult)returnResult).getProxy()) != null && (proxyResult = aProxy.getInvocation().getResult()) != null && aProxy.getExecuteResult()) {
            returnResult = proxyResult;
        }
        return returnResult;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        if (this.isExecuted()) {
            throw new IllegalStateException("Result has already been executed.");
        }
        this.resultCode = resultCode;
    }

    public OgnlValueStack getStack() {
        return this.stack;
    }

    public void addPreResultListener(PreResultListener listener) {
        if (this.preResultListeners == null) {
            this.preResultListeners = new ArrayList(1);
        }
        this.preResultListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result createResult() throws Exception {
        ActionConfig config = this.proxy.getConfig();
        Map results = config.getResults();
        ResultConfig resultConfig = null;
        ActionConfig actionConfig = config;
        synchronized (actionConfig) {
            try {
                resultConfig = (ResultConfig)results.get(this.resultCode);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (resultConfig == null) {
                resultConfig = (ResultConfig)results.get("*");
            }
        }
        if (resultConfig != null) {
            try {
                return ObjectFactory.getObjectFactory().buildResult(resultConfig, this.invocationContext.getContextMap());
            }
            catch (Exception e) {
                LOG.error((Object)("There was an exception while instantiating the result of type " + resultConfig.getClassName()), (Throwable)e);
                throw e;
            }
        }
        return null;
    }

    public String invoke() throws Exception {
        if (this.executed) {
            throw new IllegalStateException("Action has already executed");
        }
        if (this.interceptors.hasNext()) {
            InterceptorMapping interceptor = (InterceptorMapping)this.interceptors.next();
            this.resultCode = interceptor.getInterceptor().intercept(this);
        } else {
            this.resultCode = this.invokeActionOnly();
        }
        if (!this.executed) {
            if (this.preResultListeners != null) {
                Iterator iterator = this.preResultListeners.iterator();
                while (iterator.hasNext()) {
                    PreResultListener listener = (PreResultListener)iterator.next();
                    listener.beforeResult(this, this.resultCode);
                }
            }
            if (this.proxy.getExecuteResult()) {
                this.executeResult();
            }
            this.executed = true;
        }
        return this.resultCode;
    }

    public String invokeActionOnly() throws Exception {
        return this.invokeAction(this.getAction(), this.proxy.getConfig());
    }

    protected void createAction(Map contextMap) {
        try {
            this.action = ObjectFactory.getObjectFactory().buildAction(this.proxy.getActionName(), this.proxy.getNamespace(), this.proxy.getConfig(), contextMap);
        }
        catch (InstantiationException e) {
            throw new XworkException("Unable to intantiate Action!", e);
        }
        catch (IllegalAccessException e) {
            throw new XworkException("Illegal access to constructor, is it public?", e);
        }
        catch (Exception e) {
            String gripe = "";
            gripe = this.proxy == null ? "Whoa!  No ActionProxy instance found in current ActionInvocation.  This is bad ... very bad" : (this.proxy.getConfig() == null ? "Sheesh.  Where'd that ActionProxy get to?  I can't find it in the current ActionInvocation!?" : (this.proxy.getConfig().getClassName() == null ? "No Action defined for '" + this.proxy.getActionName() + "' in namespace '" + this.proxy.getNamespace() + "'" : "Unable to instantiate Action, " + this.proxy.getConfig().getClassName() + ",  defined for '" + this.proxy.getActionName() + "' in namespace '" + this.proxy.getNamespace() + "'"));
            gripe = gripe + (" -- " + e.getMessage() != null ? e.getMessage() : " [no message in exception]");
            throw new XworkException(gripe, e);
        }
        this.prepareContinuation();
    }

    private void prepareContinuation() {
        if (this.action instanceof ContinuableObject) {
            ContinuationContext ctx = ContinuationContext.createInstance((ContinuableObject)((ContinuableObject)this.action));
            if (this.action instanceof NonCloningContinuableObject) {
                ctx.setShouldClone(false);
            }
        }
        try {
            ContinuationContext context;
            String id = (String)this.stack.getContext().get("__continue");
            this.stack.getContext().remove("__continue");
            if (id != null && (context = m.getContext(id)) != null) {
                ContinuationContext.setContext((ContinuationContext)context);
                ContinuableObject original = context.getContinuable();
                this.action = original;
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    protected Map createContextMap() {
        Map contextMap;
        if (this.extraContext != null && this.extraContext.containsKey("com.opensymphony.xwork.util.OgnlValueStack.ValueStack")) {
            this.stack = (OgnlValueStack)this.extraContext.get("com.opensymphony.xwork.util.OgnlValueStack.ValueStack");
            if (this.stack == null) {
                throw new IllegalStateException("There was a null Stack set into the extra params.");
            }
            contextMap = this.stack.getContext();
        } else {
            this.stack = new OgnlValueStack();
            contextMap = this.stack.getContext();
        }
        if (this.extraContext != null) {
            contextMap.putAll(this.extraContext);
        }
        contextMap.put("com.opensymphony.xwork.ActionContext.actionInvocation", this);
        return contextMap;
    }

    private void executeResult() throws Exception {
        this.result = this.createResult();
        if (this.result != null) {
            this.result.execute(this);
        } else if (!"none".equals(this.resultCode)) {
            LOG.warn((Object)("No result defined for action " + this.getAction().getClass().getName() + " and result " + this.getResultCode()));
        }
    }

    private void init() throws Exception {
        Map contextMap = this.createContextMap();
        this.createAction(contextMap);
        if (this.pushAction) {
            this.stack.push(this.action);
        }
        this.invocationContext = new ActionContext(contextMap);
        this.invocationContext.setName(this.proxy.getActionName());
        ArrayList interceptorList = new ArrayList(this.proxy.getConfig().getInterceptors());
        this.interceptors = interceptorList.iterator();
    }

    protected String invokeAction(Object action, ActionConfig actionConfig) throws Exception {
        String methodName = this.proxy.getMethod();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing action method = " + actionConfig.getMethodName()));
        }
        try {
            Method method;
            try {
                method = this.getAction().getClass().getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    String altMethodName = "do" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
                    method = this.getAction().getClass().getMethod(altMethodName, new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    throw e;
                }
            }
            if (action instanceof Proxy) {
                try {
                    return (String)Proxy.getInvocationHandler(action).invoke(action, method, new Object[0]);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new Exception("Error invoking on proxy: " + throwable.getMessage());
                }
            }
            return (String)method.invoke(action, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Neither " + methodName + "() nor it's doXxx() equivalent is defined in action " + this.getAction().getClass() + "");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof PauseException) {
                PauseException pe = (PauseException)t;
                ContinuationContext context = pe.getContext();
                String result = (String)pe.getParameters();
                this.getStack().getContext().put("__continue", context.getId());
                m.addContext(context);
                return result;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (ContinuationConfig.getInstance() != null) {
            m = new ContinuationManager();
        }
        LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$DefaultActionInvocation == null ? (class$com$opensymphony$xwork$DefaultActionInvocation = DefaultActionInvocation.class$("com.opensymphony.xwork.DefaultActionInvocation")) : class$com$opensymphony$xwork$DefaultActionInvocation));
    }
}

