/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.Unchainable;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class DefaultTextProvider
implements TextProvider,
Serializable,
Unchainable {
    private static final Object[] EMPTY_ARGS = new Object[0];
    public static final DefaultTextProvider INSTANCE = new DefaultTextProvider();

    private DefaultTextProvider() {
    }

    public String getText(String key) {
        return LocalizedTextUtil.findDefaultText(key, ActionContext.getContext().getLocale());
    }

    public String getText(String key, String defaultValue) {
        String text = this.getText(key);
        if (text == null) {
            return defaultValue;
        }
        return text;
    }

    public String getText(String key, List args) {
        Object[] params = args != null ? args.toArray() : EMPTY_ARGS;
        return LocalizedTextUtil.findDefaultText(key, ActionContext.getContext().getLocale(), params);
    }

    public String getText(String key, String[] args) {
        Object[] params = args != null ? args : EMPTY_ARGS;
        return LocalizedTextUtil.findDefaultText(key, ActionContext.getContext().getLocale(), params);
    }

    public String getText(String key, String defaultValue, List args) {
        String text = this.getText(key, args);
        if (text == null) {
            MessageFormat format = new MessageFormat(defaultValue);
            format.setLocale(ActionContext.getContext().getLocale());
            format.applyPattern(defaultValue);
            Object[] params = args != null ? args.toArray() : EMPTY_ARGS;
            return format.format(params);
        }
        return text;
    }

    public String getText(String key, String defaultValue, String[] args) {
        String text = this.getText(key, args);
        if (text == null) {
            MessageFormat format = new MessageFormat(defaultValue);
            format.setLocale(ActionContext.getContext().getLocale());
            format.applyPattern(defaultValue);
            if (args == null) {
                return format.format(EMPTY_ARGS);
            }
            return format.format(args);
        }
        return text;
    }

    public String getText(String key, String defaultValue, String obj) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(obj);
        return this.getText(key, defaultValue, args);
    }

    public String getText(String key, String defaultValue, List args, OgnlValueStack stack) {
        return this.getText(key, defaultValue, args);
    }

    public String getText(String key, String defaultValue, String[] args, OgnlValueStack stack) {
        return this.getText(key, defaultValue, Arrays.asList(args));
    }

    public ResourceBundle getTexts(String bundleName) {
        return LocalizedTextUtil.findResourceBundle(bundleName, ActionContext.getContext().getLocale());
    }

    public ResourceBundle getTexts() {
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

