/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.util.TextParseUtil;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MethodFilterInterceptor
implements Interceptor {
    protected transient Log log = LogFactory.getLog(this.getClass());
    protected Set excludeMethods = Collections.EMPTY_SET;
    protected Set includeMethods = Collections.EMPTY_SET;

    public void setExcludeMethods(String excludeMethods) {
        this.excludeMethods = TextParseUtil.commaDelimitedStringToSet(excludeMethods);
    }

    public void setIncludeMethods(String includeMethods) {
        this.includeMethods = TextParseUtil.commaDelimitedStringToSet(includeMethods);
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (this.applyInterceptor(invocation)) {
            return this.doIntercept(invocation);
        }
        return invocation.invoke();
    }

    protected boolean applyInterceptor(ActionInvocation invocation) {
        String method = invocation.getProxy().getMethod();
        if ((this.excludeMethods.contains("*") && !this.includeMethods.contains("*") || this.excludeMethods.contains(method)) && !this.includeMethods.contains(method)) {
            this.log.debug((Object)("Skipping Interceptor... Method [" + method + "] found in exclude list."));
            return false;
        }
        return this.includeMethods.size() == 0 || this.includeMethods.contains(method) || this.includeMethods.contains("*");
    }

    protected abstract String doIntercept(ActionInvocation var1) throws Exception;

    public void destroy() {
    }

    public void init() {
    }
}

