/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import com.opensymphony.xwork.interceptor.NoParameters;
import com.opensymphony.xwork.interceptor.ParameterNameAware;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParametersInterceptor
extends AroundInterceptor {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$interceptor$ParametersInterceptor == null ? (class$com$opensymphony$xwork$interceptor$ParametersInterceptor = ParametersInterceptor.class$("com.opensymphony.xwork.interceptor.ParametersInterceptor")) : class$com$opensymphony$xwork$interceptor$ParametersInterceptor));
    static /* synthetic */ Class class$com$opensymphony$xwork$interceptor$ParametersInterceptor;

    protected void after(ActionInvocation dispatcher, String result) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void before(ActionInvocation invocation) throws Exception {
        if (!(invocation.getAction() instanceof NoParameters)) {
            ActionContext ac = invocation.getInvocationContext();
            Map parameters = ac.getParameters();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting params " + this.getParameterLogMap(parameters)));
            }
            if (parameters != null) {
                try {
                    ac.put("xwork.NullHandler.createNullObjects", Boolean.TRUE);
                    ac.put("xwork.MethodAccessor.denyMethodExecution", Boolean.TRUE);
                    ac.put("report.conversion.errors", Boolean.TRUE);
                    OgnlValueStack stack = ac.getValueStack();
                    this.setParameters(invocation.getAction(), stack, parameters);
                }
                finally {
                    ac.put("xwork.NullHandler.createNullObjects", Boolean.FALSE);
                    ac.put("xwork.MethodAccessor.denyMethodExecution", Boolean.FALSE);
                    ac.put("report.conversion.errors", Boolean.FALSE);
                }
            }
        }
    }

    protected void setParameters(Object action, OgnlValueStack stack, Map parameters) {
        ParameterNameAware parameterNameAware = action instanceof ParameterNameAware ? (ParameterNameAware)action : null;
        Iterator iterator = new TreeMap(parameters).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = entry.getKey().toString();
            boolean acceptableName = this.acceptableName(name) && (parameterNameAware == null || parameterNameAware.acceptableParameterName(name));
            if (!acceptableName) continue;
            Object value = entry.getValue();
            try {
                stack.setValue(name, value);
            }
            catch (RuntimeException e) {
                Boolean devMode = (Boolean)stack.getContext().get("__devMode");
                if (devMode != null && devMode.booleanValue()) {
                    String developerNotification = LocalizedTextUtil.findText(class$com$opensymphony$xwork$interceptor$ParametersInterceptor == null ? ParametersInterceptor.class$("com.opensymphony.xwork.interceptor.ParametersInterceptor") : class$com$opensymphony$xwork$interceptor$ParametersInterceptor, "webwork.messages.devmode.notification", ActionContext.getContext().getLocale(), "Developer Notification (set webwork.devMode to false to disable this message):\n{0}", new Object[]{e.getMessage()});
                    LOG.error((Object)developerNotification);
                    if (!(action instanceof ValidationAware)) continue;
                    ((ValidationAware)action).addActionMessage(developerNotification);
                    continue;
                }
                LOG.error((Object)("ParametersInterceptor - [setParameters]: Unexpected Exception catched: " + e.getMessage()));
            }
        }
    }

    private String getParameterLogMap(Map parameters) {
        if (parameters == null) {
            return "NONE";
        }
        StringBuffer logEntry = new StringBuffer();
        Iterator paramIter = parameters.entrySet().iterator();
        while (paramIter.hasNext()) {
            Map.Entry entry = paramIter.next();
            logEntry.append(String.valueOf(entry.getKey()));
            logEntry.append(" => ");
            if (entry.getValue() instanceof Object[]) {
                Object[] valueArray = (Object[])entry.getValue();
                logEntry.append("[ ");
                for (int indexA = 0; indexA < valueArray.length - 1; ++indexA) {
                    Object valueAtIndex = valueArray[indexA];
                    logEntry.append(valueAtIndex);
                    logEntry.append(String.valueOf(valueAtIndex));
                    logEntry.append(", ");
                }
                logEntry.append(String.valueOf(valueArray[valueArray.length - 1]));
                logEntry.append(" ] ");
                continue;
            }
            logEntry.append(String.valueOf(entry.getValue()));
        }
        return logEntry.toString();
    }

    protected boolean acceptableName(String name) {
        return name.indexOf(61) == -1 && name.indexOf(44) == -1 && name.indexOf(35) == -1 && name.indexOf(58) == -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

