/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator.validators;

import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.validators.FieldValidatorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringRegexValidator
extends FieldValidatorSupport {
    private String regex = ".";
    private boolean caseSensitive = true;

    public void validate(Object object) throws ValidationException {
        String fieldName = this.getFieldName();
        String value = (String)this.getFieldValue(fieldName, object);
        if (value == null) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        Pattern pattern = null;
        pattern = this.isCaseSensitive() ? Pattern.compile(this.getRegex()) : Pattern.compile(this.getRegex(), 2);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            this.addFieldError(fieldName, object);
        }
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

