/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit;

import java.sql.SQLException;
import org.arquillian.ape.rdbms.CleanupStrategy;
import org.arquillian.ape.rdbms.DataSeedStrategy;
import org.arquillian.ape.rdbms.core.data.DataHandler;
import org.arquillian.ape.rdbms.core.event.CleanupData;
import org.arquillian.ape.rdbms.core.event.CleanupDataUsingScript;
import org.arquillian.ape.rdbms.core.event.ExecuteScripts;
import org.arquillian.ape.rdbms.core.metadata.PersistenceExtensionFeatureResolver;
import org.arquillian.ape.rdbms.core.test.AssertionErrorCollector;
import org.arquillian.ape.rdbms.dbunit.DataSetComparator;
import org.arquillian.ape.rdbms.dbunit.DataSetUtils;
import org.arquillian.ape.rdbms.dbunit.cleanup.CleanupStrategyExecutor;
import org.arquillian.ape.rdbms.dbunit.cleanup.CleanupStrategyProvider;
import org.arquillian.ape.rdbms.dbunit.configuration.DBUnitConfiguration;
import org.arquillian.ape.rdbms.dbunit.configuration.DBUnitDataSeedStrategyProvider;
import org.arquillian.ape.rdbms.dbunit.dataset.DataSetRegister;
import org.arquillian.ape.rdbms.dbunit.event.CompareDBUnitData;
import org.arquillian.ape.rdbms.dbunit.event.PrepareDBUnitData;
import org.arquillian.ape.rdbms.dbunit.exception.DBUnitConnectionException;
import org.arquillian.ape.rdbms.dbunit.exception.DBUnitDataSetHandlingException;
import org.arquillian.ape.rdbms.dbunit.filter.TableFilterResolver;
import org.arquillian.ape.rdbms.script.ScriptExecutor;
import org.arquillian.ape.rdbms.script.configuration.ScriptingConfiguration;
import org.arquillian.ape.rdbms.script.data.descriptor.SqlScriptResourceDescriptor;
import org.arquillian.ape.rdbms.script.splitter.StatementSplitterResolver;
import org.arquillian.ape.spi.dbunit.filter.TableFilterProvider;
import org.arquillian.ape.spi.script.StatementSplitter;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ExcludeTableFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.operation.DatabaseOperation;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class DBUnitDataHandler
implements DataHandler<PrepareDBUnitData, CompareDBUnitData> {
    @Inject
    private Instance<DatabaseConnection> databaseConnection;
    @Inject
    private Instance<DataSetRegister> dataSetRegister;
    @Inject
    private Instance<AssertionErrorCollector> assertionErrorCollector;
    @Inject
    private Instance<DBUnitConfiguration> dbunitConfigurationInstance;
    @Inject
    private Instance<ScriptingConfiguration> scriptConfigurationInstance;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolverInstance;

    public void prepare(@Observes PrepareDBUnitData prepareDataEvent) {
        try {
            this.seedDatabase();
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Failed while seeding database.", e);
        }
    }

    public void compare(@Observes CompareDBUnitData compareDataEvent) {
        try {
            IDataSet currentDataSet = ((DatabaseConnection)this.databaseConnection.get()).createDataSet();
            String[] excludeTables = ((DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get())).getExcludeTablesFromComparisonWhenEmptyExpected();
            if (excludeTables.length != 0) {
                currentDataSet = new FilteredDataSet((ITableFilter)new ExcludeTableFilter(excludeTables), currentDataSet);
            }
            IDataSet expectedDataSet = DataSetUtils.mergeDataSets(((DataSetRegister)this.dataSetRegister.get()).getExpected());
            DataSetComparator dataSetComparator = new DataSetComparator(compareDataEvent.getSortByColumns(), compareDataEvent.getColumnsToExclude(), compareDataEvent.getCustomColumnFilters());
            dataSetComparator.compare(currentDataSet, expectedDataSet, (AssertionErrorCollector)this.assertionErrorCollector.get());
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Failed while comparing database state with provided data sets.", e);
        }
    }

    public void cleanup(@Observes CleanupData cleanupDataEvent) {
        this.cleanDatabase(cleanupDataEvent.cleanupStrategy);
    }

    public void cleanupUsingScript(@Observes CleanupDataUsingScript cleanupDataUsingScriptEvent) {
        for (SqlScriptResourceDescriptor scriptDescriptor : cleanupDataUsingScriptEvent.getDescriptors()) {
            String script = (String)scriptDescriptor.getContent();
            this.executeScript(script);
        }
    }

    public void executeScripts(@Observes ExecuteScripts executeScriptsEvent) {
        for (SqlScriptResourceDescriptor scriptDescriptor : executeScriptsEvent.getDescriptors()) {
            String script = (String)scriptDescriptor.getContent();
            this.executeScript(script);
        }
    }

    private void executeScript(String script) {
        try {
            StatementSplitter statementSplitter = new StatementSplitterResolver((ScriptingConfiguration)this.scriptConfigurationInstance.get()).resolve();
            ScriptExecutor scriptExecutor = new ScriptExecutor(((DatabaseConnection)this.databaseConnection.get()).getConnection(), (ScriptingConfiguration)this.scriptConfigurationInstance.get(), statementSplitter);
            scriptExecutor.execute(script);
        }
        catch (SQLException e) {
            throw new DBUnitConnectionException("Unable to execute script.", e);
        }
    }

    private void seedDatabase() throws Exception {
        DatabaseConnection connection = (DatabaseConnection)this.databaseConnection.get();
        IDataSet initialDataSet = DataSetUtils.mergeDataSets(((DataSetRegister)this.dataSetRegister.get()).getInitial());
        if (((DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get())).isFilterTables()) {
            TableFilterProvider sequenceFilterProvider = new TableFilterResolver((DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get())).resolve();
            ITableFilter databaseSequenceFilter = sequenceFilterProvider.provide((IDatabaseConnection)connection, initialDataSet.getTableNames());
            initialDataSet = new FilteredDataSet(databaseSequenceFilter, initialDataSet);
        }
        this.seedingStrategy().execute((IDatabaseConnection)connection, initialDataSet);
    }

    private DatabaseOperation seedingStrategy() {
        DBUnitConfiguration dbUnitConfiguration = (DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get());
        DataSeedStrategy dataSeedStrategy = ((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get()).getDataSeedStrategy();
        boolean useIdentityInsert = dbUnitConfiguration.isUseIdentityInsert();
        return (DatabaseOperation)dataSeedStrategy.provide((DataSeedStrategy.StrategyProvider)new DBUnitDataSeedStrategyProvider(useIdentityInsert));
    }

    private void cleanDatabase(CleanupStrategy cleanupStrategy) {
        CleanupStrategyExecutor cleanupStrategyExecutor = (CleanupStrategyExecutor)cleanupStrategy.provide((CleanupStrategy.StrategyProvider)new CleanupStrategyProvider((DatabaseConnection)this.databaseConnection.get(), (DataSetRegister)this.dataSetRegister.get(), (DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get())));
        cleanupStrategyExecutor.cleanupDatabase(((DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get())).getExcludeTablesFromCleanup());
    }
}

