/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit.cleanup;

import org.arquillian.ape.rdbms.CleanupStrategy;
import org.arquillian.ape.rdbms.dbunit.cleanup.CleanupStrategyExecutor;
import org.arquillian.ape.rdbms.dbunit.cleanup.SeededDataOnlyCleanupStrategyExecutor;
import org.arquillian.ape.rdbms.dbunit.cleanup.StrictCleanupStrategyExecutor;
import org.arquillian.ape.rdbms.dbunit.cleanup.UsedTablesOnlyCleanupStrategyExecutor;
import org.arquillian.ape.rdbms.dbunit.configuration.DBUnitConfiguration;
import org.arquillian.ape.rdbms.dbunit.dataset.DataSetRegister;
import org.dbunit.database.DatabaseConnection;

public class CleanupStrategyProvider
implements CleanupStrategy.StrategyProvider<CleanupStrategyExecutor> {
    private final DatabaseConnection connection;
    private final DataSetRegister register;
    private final DBUnitConfiguration dbUnitConfiguration;

    public CleanupStrategyProvider(DatabaseConnection connection, DataSetRegister register, DBUnitConfiguration dbUnitConfiguration) {
        this.connection = connection;
        this.register = register != null ? register : new DataSetRegister();
        this.dbUnitConfiguration = dbUnitConfiguration;
    }

    public CleanupStrategyExecutor strictStrategy() {
        return new StrictCleanupStrategyExecutor(this.connection, this.dbUnitConfiguration);
    }

    public CleanupStrategyExecutor usedTablesOnlyStrategy() {
        return new UsedTablesOnlyCleanupStrategyExecutor(this.connection, this.register, this.dbUnitConfiguration);
    }

    public CleanupStrategyExecutor usedRowsOnlyStrategy() {
        return new SeededDataOnlyCleanupStrategyExecutor(this.connection, this.register, this.dbUnitConfiguration);
    }

    public CleanupStrategyExecutor defaultStrategy() {
        return new StrictCleanupStrategyExecutor(this.connection, this.dbUnitConfiguration);
    }
}

