/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit.configuration;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.ape.rdbms.core.util.Strings;
import org.arquillian.ape.rdbms.dbunit.configuration.DBUnitConfiguration;
import org.arquillian.ape.rdbms.dbunit.configuration.DBUnitConfigurationDefinitionException;
import org.arquillian.ape.rdbms.dbunit.configuration.ReflectionHelper;
import org.arquillian.ape.rdbms.dbunit.configuration.annotations.Feature;
import org.arquillian.ape.rdbms.dbunit.configuration.annotations.Property;

public class DBUnitConfigurationPropertyMapper {
    private static final String FEATURE_PREFIX = "http://www.dbunit.org/features/";
    private static final String PROPERTY_PREFIX = "http://www.dbunit.org/properties/";

    public Map<String, Object> map(DBUnitConfiguration configuration) {
        HashMap<String, Object> convertedProperties = new HashMap<String, Object>();
        this.mapProperties(configuration, convertedProperties);
        this.mapFeatures(configuration, convertedProperties);
        return convertedProperties;
    }

    private void mapFeatures(DBUnitConfiguration configuration, Map<String, Object> convertedProperties) {
        List<Field> features = ReflectionHelper.getFieldsWithAnnotation(DBUnitConfiguration.class, Feature.class);
        try {
            for (Field feature : features) {
                String featurePrefix = FEATURE_PREFIX;
                Feature featureAnnotation = feature.getAnnotation(Feature.class);
                if (!Strings.isEmpty((String)featureAnnotation.value())) {
                    featurePrefix = featurePrefix + featureAnnotation.value() + "/";
                }
                String key = featurePrefix + feature.getName();
                Object value = feature.get((Object)configuration);
                if (value == null) continue;
                convertedProperties.put(key, value);
            }
        }
        catch (Exception e) {
            throw new DBUnitConfigurationDefinitionException("Unable to map DBUnit settings.", e);
        }
    }

    private void mapProperties(DBUnitConfiguration configuration, Map<String, Object> convertedProperties) {
        List<Field> properties = ReflectionHelper.getFieldsWithAnnotation(DBUnitConfiguration.class, Property.class);
        try {
            for (Field property : properties) {
                String propertyPrefix = PROPERTY_PREFIX;
                Property propertyAnnotation = property.getAnnotation(Property.class);
                if (!Strings.isEmpty((String)propertyAnnotation.value())) {
                    propertyPrefix = propertyPrefix + propertyAnnotation.value() + "/";
                }
                String key = propertyPrefix + property.getName();
                Object value = property.get((Object)configuration);
                if (value == null) continue;
                convertedProperties.put(key, value);
            }
        }
        catch (Exception e) {
            throw new DBUnitConfigurationDefinitionException("Unable to map DBUnit settings.", e);
        }
    }
}

