/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit.data.provider;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.arquillian.ape.rdbms.ShouldMatchDataSet;
import org.arquillian.ape.rdbms.core.data.descriptor.Format;
import org.arquillian.ape.rdbms.core.data.provider.ResourceProvider;
import org.arquillian.ape.rdbms.core.exception.UnsupportedDataFormatException;
import org.arquillian.ape.rdbms.core.metadata.MetadataExtractor;
import org.arquillian.ape.rdbms.dbunit.configuration.DBUnitConfiguration;
import org.arquillian.ape.rdbms.dbunit.data.descriptor.DataSetResourceDescriptor;
import org.arquillian.ape.rdbms.dbunit.data.naming.ExpectedDataSetFileNamingStrategy;

public class ExpectedDataSetProvider
extends ResourceProvider<DataSetResourceDescriptor> {
    private final DBUnitConfiguration configuration;

    public ExpectedDataSetProvider(MetadataExtractor metadataExtractor, DBUnitConfiguration configuration) {
        super(ShouldMatchDataSet.class, metadataExtractor);
        this.configuration = configuration;
    }

    protected DataSetResourceDescriptor createDescriptor(String resource) {
        return new DataSetResourceDescriptor(this.determineLocation(resource), this.inferFormat(resource));
    }

    protected String defaultLocation() {
        return this.configuration.getDefaultDataSetLocation();
    }

    protected String defaultFileName() {
        Format format = this.configuration.getDefaultDataSetFormat();
        return new ExpectedDataSetFileNamingStrategy(format).createFileName(this.metadataExtractor.getJavaClass());
    }

    public Collection<String> getResourceFileNames(Method testMethod) {
        ShouldMatchDataSet dataAnnotation = this.getResourceAnnotation(testMethod);
        String[] specifiedFileNames = dataAnnotation.value();
        if (specifiedFileNames.length == 0 || "".equals(specifiedFileNames[0].trim())) {
            return Collections.singletonList(this.getDefaultFileName(testMethod));
        }
        return Arrays.asList(specifiedFileNames);
    }

    private Format inferFormat(String dataFileName) {
        Format format = Format.inferFromFile((String)dataFileName);
        if (Format.UNSUPPORTED.equals((Object)format)) {
            throw new UnsupportedDataFormatException("File " + dataFileName + " is not supported as data set format.");
        }
        return format;
    }

    List<Format> getDataFormats(Method testMethod) {
        ArrayList<Format> formats = new ArrayList<Format>();
        for (String dataFileName : this.getResourceFileNames(testMethod)) {
            formats.add(this.inferFormat(dataFileName));
        }
        return formats;
    }

    private ShouldMatchDataSet getResourceAnnotation(Method testMethod) {
        return (ShouldMatchDataSet)this.metadataExtractor.shouldMatchDataSet().fetchUsingFirst(testMethod);
    }

    private String getDefaultFileName(Method testMethod) {
        Format format = this.configuration.getDefaultDataSetFormat();
        if (this.metadataExtractor.shouldMatchDataSet().isDefinedOn(testMethod)) {
            return new ExpectedDataSetFileNamingStrategy(format).createFileName(this.metadataExtractor.getJavaClass(), testMethod);
        }
        return new ExpectedDataSetFileNamingStrategy(format).createFileName(this.metadataExtractor.getJavaClass());
    }
}

