/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit.dataset;

import java.util.HashMap;
import java.util.Map;

public class Row {
    private final Map<String, String> cells = new HashMap<String, String>();

    public Row(Map<String, String> cells) {
        for (Map.Entry<String, String> cell : cells.entrySet()) {
            this.cells.put(String.valueOf(cell.getKey()), String.valueOf(cell.getValue()));
        }
    }

    public String valueOf(String name) {
        return this.cells.get(name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row other = (Row)obj;
        Map<String, String> otherCells = other.cells;
        if (this.cells.size() != otherCells.size()) {
            return false;
        }
        for (Map.Entry<String, String> cell : this.cells.entrySet()) {
            String name = cell.getKey();
            String value = cell.getValue();
            if (value.equals(otherCells.get(name))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 17;
        int result = 1;
        result = 17 * result + (this.cells == null ? 0 : this.cellHashCode());
        return result;
    }

    public String toString() {
        return "Row [cells=" + this.toString(this.cells) + "]";
    }

    private String toString(Map<String, String> cells2) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> cell : this.cells.entrySet()) {
            sb.append("{key = ").append(cell.getKey()).append(", value = ").append(cell.getValue()).append("} ");
        }
        return sb.toString();
    }

    private int cellHashCode() {
        int prime = 41;
        int result = 1;
        for (Map.Entry<String, String> cell : this.cells.entrySet()) {
            result = 41 * result + cell.getKey().hashCode();
            result = 41 * result + cell.getValue().hashCode();
        }
        return result;
    }
}

