/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit.dataset.json;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.arquillian.ape.rdbms.dbunit.dataset.Row;
import org.arquillian.ape.rdbms.dbunit.dataset.Table;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;

public abstract class DataSetProducer
implements IDataSetProducer {
    protected final InputStream input;
    private boolean caseSensitiveTableNames;
    private IDataSetConsumer consumer = new DefaultConsumer();

    public DataSetProducer(InputStream input) {
        this.input = input;
    }

    abstract Map<String, List<Map<String, String>>> loadDataSet() throws DataSetException;

    public void setConsumer(IDataSetConsumer consumer) {
        this.consumer = consumer;
    }

    public void produce() throws DataSetException {
        this.consumer.startDataSet();
        Map<String, List<Map<String, String>>> dataset = this.loadDataSet();
        List<Table> tables = this.createTables(dataset);
        for (Table table : tables) {
            ITableMetaData tableMetaData = this.createTableMetaData(table);
            this.consumer.startTable(tableMetaData);
            for (Row row : table.getRows()) {
                ArrayList<String> values = new ArrayList<String>();
                for (Column column : tableMetaData.getColumns()) {
                    values.add(row.valueOf(column.getColumnName()));
                }
                this.consumer.row(values.toArray());
            }
            this.consumer.endTable();
        }
        this.consumer.endDataSet();
    }

    private ITableMetaData createTableMetaData(Table table) {
        return new DefaultTableMetaData(table.getTableName(), this.createColumns(table.getColumns()));
    }

    private Column[] createColumns(Collection<String> columnNames) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String columnName : columnNames) {
            Column column = new Column(columnName, DataType.UNKNOWN);
            columns.add(column);
        }
        return columns.toArray(new Column[columns.size()]);
    }

    private List<Table> createTables(Map<String, List<Map<String, String>>> jsonStructure) {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Map.Entry<String, List<Map<String, String>>> entry : jsonStructure.entrySet()) {
            Table table = new Table(entry.getKey());
            table.addColumns(this.extractColumns(entry.getValue()));
            table.addRows(this.extractRows(entry.getValue()));
            tables.add(table);
        }
        return tables;
    }

    private Collection<Row> extractRows(List<Map<String, String>> rows) {
        ArrayList<Row> extractedRows = new ArrayList<Row>();
        for (Map<String, String> row : rows) {
            extractedRows.add(new Row(row));
        }
        return extractedRows;
    }

    private Collection<String> extractColumns(List<Map<String, String>> rows) {
        HashSet<String> columns = new HashSet<String>();
        for (Map<String, String> row : rows) {
            columns.addAll(row.keySet());
        }
        return columns;
    }

    public boolean isCaseSensitiveTableNames() {
        return this.caseSensitiveTableNames;
    }

    public void setCaseSensitiveTableNames(boolean caseSensitiveTableNames) {
        this.caseSensitiveTableNames = caseSensitiveTableNames;
    }
}

