/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit.dataset.yaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.arquillian.ape.rdbms.dbunit.dataset.Row;
import org.arquillian.ape.rdbms.dbunit.dataset.Table;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class YamlDataSetProducer
implements IDataSetProducer {
    private final InputStream input;
    private boolean caseSensitiveTableNames;
    private IDataSetConsumer consumer = new DefaultConsumer();

    public YamlDataSetProducer(InputStream inputStream) {
        this.input = inputStream;
    }

    public void setConsumer(IDataSetConsumer consumer) {
        this.consumer = consumer;
    }

    public void produce() throws DataSetException {
        this.consumer.startDataSet();
        List<Table> tables = this.createTables((Map)this.createYamlReader().load(this.input));
        for (Table table : tables) {
            ITableMetaData tableMetaData = this.createTableMetaData(table);
            this.consumer.startTable(tableMetaData);
            for (Row row : table.getRows()) {
                ArrayList<String> values = new ArrayList<String>();
                for (Column column : tableMetaData.getColumns()) {
                    values.add(row.valueOf(column.getColumnName()));
                }
                this.consumer.row(values.toArray());
            }
            this.consumer.endTable();
        }
        this.consumer.endDataSet();
    }

    public Yaml createYamlReader() {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(), new Representer(), new DumperOptions(), new Resolver(){

            protected void addImplicitResolvers() {
                this.addImplicitResolver(Tag.BOOL, BOOL, "yYnNtTfFoO");
                this.addImplicitResolver(Tag.INT, INT, "-+0123456789");
                this.addImplicitResolver(Tag.FLOAT, FLOAT, "-+0123456789.");
                this.addImplicitResolver(Tag.MERGE, MERGE, "<");
                this.addImplicitResolver(Tag.NULL, NULL, "~nN\u0000");
                this.addImplicitResolver(Tag.NULL, EMPTY, null);
                this.addImplicitResolver(Tag.YAML, YAML, "!&*");
            }
        });
        return yaml;
    }

    private ITableMetaData createTableMetaData(Table table) {
        return new DefaultTableMetaData(table.getTableName(), this.createColumns(table.getColumns()));
    }

    private Column[] createColumns(Collection<String> columnNames) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String columnName : columnNames) {
            Column column = new Column(columnName, DataType.UNKNOWN);
            columns.add(column);
        }
        return columns.toArray(new Column[columns.size()]);
    }

    private List<Table> createTables(Map<String, List<Map<String, String>>> yamlStructure) {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Map.Entry<String, List<Map<String, String>>> entry : yamlStructure.entrySet()) {
            Table table = new Table(entry.getKey());
            table.addColumns(this.extractColumns(entry.getValue()));
            table.addRows(this.extractRows(entry.getValue()));
            tables.add(table);
        }
        return tables;
    }

    private Collection<Row> extractRows(List<Map<String, String>> rows) {
        ArrayList<Row> extractedRows = new ArrayList<Row>();
        if (rows == null || rows.isEmpty()) {
            return extractedRows;
        }
        for (Map<String, String> row : rows) {
            extractedRows.add(new Row(row));
        }
        return extractedRows;
    }

    private Collection<String> extractColumns(List<Map<String, String>> rows) {
        HashSet<String> columns = new HashSet<String>();
        if (rows == null || rows.isEmpty()) {
            return columns;
        }
        for (Map<String, String> row : rows) {
            columns.addAll(row.keySet());
        }
        return columns;
    }

    public boolean isCaseSensitiveTableNames() {
        return this.caseSensitiveTableNames;
    }

    public void setCaseSensitiveTableNames(boolean caseSensitiveTableNames) {
        this.caseSensitiveTableNames = caseSensitiveTableNames;
    }
}

