/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.ape.rdbms.dbunit.deployment;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.arquillian.ape.rdbms.core.configuration.PropertiesSerializer;
import org.arquillian.ape.rdbms.core.deployment.ResourceAppender;
import org.arquillian.ape.rdbms.core.metadata.PersistenceExtensionEnabler;
import org.arquillian.ape.rdbms.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class DBUnitConfigurationTestArchiveEnricher
implements ApplicationArchiveProcessor {
    private static final Logger log = Logger.getLogger(DBUnitConfigurationTestArchiveEnricher.class.getName());
    @Inject
    Instance<ArquillianDescriptor> arquillianDescriptorInstance;

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        PersistenceExtensionEnabler persistenceExtensionEnabler = new PersistenceExtensionEnabler(testClass);
        if (!persistenceExtensionEnabler.shouldPersistenceExtensionBeActivated()) {
            return;
        }
        JavaArchive additionalPersistenceResources = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arquillian-persistence-dbunit-additional-resources.jar");
        this.merge(additionalPersistenceResources, this.dbUnitConfigurationSerializedAsProperties());
        ResourceAppender.addResources(applicationArchive, (JavaArchive)additionalPersistenceResources);
    }

    private void merge(JavaArchive target, JavaArchive ... archivesToMerge) {
        for (JavaArchive archiveToMerge : archivesToMerge) {
            target.merge((Archive)archiveToMerge);
        }
    }

    private JavaArchive dbUnitConfigurationSerializedAsProperties() {
        DBUnitConfiguration dbUnitConfigurationPrototype = new DBUnitConfiguration();
        Map<String, String> extensionProperties = this.extractExtensionProperties((ArquillianDescriptor)this.arquillianDescriptorInstance.get(), dbUnitConfigurationPrototype.getQualifier());
        ByteArrayOutputStream properties = new PropertiesSerializer(dbUnitConfigurationPrototype.getPrefix()).serializeToProperties(extensionProperties);
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource((Asset)new ByteArrayAsset(properties.toByteArray()), new DBUnitConfiguration().getPrefix() + "properties");
    }

    private Map<String, String> extractExtensionProperties(ArquillianDescriptor descriptor, String qualifier) {
        HashMap<String, String> extensionProperties = new HashMap<String, String>();
        for (ExtensionDef extension : descriptor.getExtensions()) {
            if (!extension.getExtensionName().equals(qualifier)) continue;
            extensionProperties.putAll(extension.getExtensionProperties());
            break;
        }
        return extensionProperties;
    }
}

