/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.deployment.file;

import java.nio.file.Paths;
import org.arquillian.container.chameleon.deployment.api.AbstractAutomaticDeployment;
import org.arquillian.container.chameleon.deployment.file.File;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;

public class FileAutomaticDeployment
extends AbstractAutomaticDeployment {
    protected Archive<?> build(TestClass testClass) {
        if (testClass.isAnnotationPresent(File.class)) {
            File file = (File)testClass.getAnnotation(File.class);
            String location = file.value();
            java.io.File archiveLocation = new java.io.File(location);
            if (!archiveLocation.isAbsolute()) {
                String rootPath = Paths.get(".", new String[0]).toAbsolutePath().toString();
                archiveLocation = new java.io.File(rootPath, location);
            }
            return (Archive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)this.getArchiveName(location))).importFrom(archiveLocation)).as(file.type());
        }
        return null;
    }

    private String getArchiveName(String deploymentFileLocation) {
        return deploymentFileLocation.substring(deploymentFileLocation.lastIndexOf(java.io.File.separatorChar) + 1);
    }
}

