/*
 * JBoss, Home of Professional Open Source
 * Copyright 2016 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.arquillian.container.chameleon;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

import javax.inject.Inject;

import static org.arquillian.container.chameleon.Deployments.enrichTomcatWithCdi;

@RunWith(Arquillian.class)
public class SimpleDeploymentTestCase {

    @Deployment
    public static WebArchive deploy() {
        final String container = System.getProperty("arq.container.chameleon.configuration.chameleonTarget", "chameleon/default");
        final WebArchive archive = ShrinkWrap.create(WebArchive.class)
                .addAsWebInfResource(EmptyAsset.INSTANCE, "beans.xml")
                .addClass(SimpleBean.class);

        if (container.contains("tomcat")) {
            enrichTomcatWithCdi(archive);
        }

        return archive;
    }

    @Inject
    private SimpleBean bean;

    @Test
    public void shouldNotBeNull() {
        Assert.assertNotNull(bean);
    }

    @Test
    public void shouldReturnName() {
        Assert.assertEquals("Proxy", bean.getName());
    }

}
