/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.runner;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Comparator;
import org.arquillian.container.chameleon.api.ChameleonTarget;
import org.arquillian.container.chameleon.runner.ChameleonTargetConfiguration;

public class AnnotationExtractor {
    public static ChameleonTargetConfiguration extract(Annotation annotation) {
        Annotation[] metaAnnotations;
        Class<? extends Annotation> annotationType = annotation.annotationType();
        ChameleonTargetConfiguration currentConfiguration = null;
        if (annotationType == ChameleonTarget.class) {
            ChameleonTarget chameleonTarget = (ChameleonTarget)annotation;
            return ChameleonTargetConfiguration.from(chameleonTarget);
        }
        for (Annotation metaAnnotation : metaAnnotations = AnnotationExtractor.findAndSortAnnotations(annotation)) {
            if (metaAnnotation.annotationType().getName().startsWith("java.lang")) continue;
            ChameleonTargetConfiguration chameleonTargetConfiguration = AnnotationExtractor.extract(metaAnnotation);
            currentConfiguration = currentConfiguration != null ? currentConfiguration.importConfiguration(chameleonTargetConfiguration) : chameleonTargetConfiguration;
        }
        return currentConfiguration;
    }

    static Annotation[] findAndSortAnnotations(Annotation annotation) {
        Annotation[] metaAnnotations = annotation.annotationType().getAnnotations();
        Arrays.sort(metaAnnotations, new Comparator<Annotation>(){

            @Override
            public int compare(Annotation o1, Annotation o2) {
                if (o1 instanceof ChameleonTarget) {
                    return -1;
                }
                if (o2 instanceof ChameleonTarget) {
                    return 1;
                }
                return 0;
            }
        });
        return metaAnnotations;
    }
}

