/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.runner;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.arquillian.container.chameleon.runner.ArquillianChameleonConfigurator;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class ArquillianChameleon
extends Arquillian {
    private static final Logger log = Logger.getLogger(ArquillianChameleon.class.getName());

    public ArquillianChameleon(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        Class testClass = this.getTestClass().getJavaClass();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<ArquillianChameleon> clazz = ArquillianChameleon.class;
        synchronized (ArquillianChameleon.class) {
            if (this.isInClientSide(classLoader) && !this.isSpecialChameleonFile(classLoader)) {
                try {
                    Path arquillianChameleonConfiguration = new ArquillianChameleonConfigurator().setup(testClass, classLoader);
                    log.info(String.format("Arquillian Configuration created by Chameleon runner is placed at %s.", arquillianChameleonConfiguration.toFile().getAbsolutePath()));
                    this.createChameleonMarkerFile(arquillianChameleonConfiguration.getParent());
                    this.addsArquillianFile(arquillianChameleonConfiguration.getParent(), classLoader);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            super.run(notifier);
            return;
        }
    }

    private void createChameleonMarkerFile(Path parent) throws IOException {
        Path chameleon = parent.resolve("chameleonrunner");
        Files.write(chameleon, "Chameleon Runner was there".getBytes(), new OpenOption[0]);
    }

    private boolean isSpecialChameleonFile(ClassLoader parent) {
        return parent.getResource("chameleonrunner") != null;
    }

    private boolean isInClientSide(ClassLoader parent) {
        return parent.getResourceAsStream("chameleonrunner.txt") == null;
    }

    private void addsArquillianFile(Path file, ClassLoader classLoader) throws Exception {
        URL url = file.toUri().toURL();
        URLClassLoader wrappedClassLoader = URLClassLoader.newInstance(new URL[]{url}, classLoader);
        Thread.currentThread().setContextClassLoader(wrappedClassLoader);
    }
}

