/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.runner;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.arquillian.container.chameleon.runner.AnnotationExtractor;
import org.arquillian.container.chameleon.runner.ChameleonTargetConfiguration;
import org.arquillian.container.chameleon.runner.DomManipulation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArquillianChameleonConfigurationGenerator {
    static final String ARQUILLIAN_CHAMELEON_XML = "arquillianchameleon.xml";
    static final String ARQUILLIAN_XML = "arquillian.xml";
    static final String ARQUILLIAN_PROPERTIES = "arquillian.properties";

    public Path generateNewArquillianProperties(Class<?> testClass) throws IOException {
        ChameleonTargetConfiguration chameleonTargetConfiguration = this.findChameleonTargetConfiguration(testClass);
        if (chameleonTargetConfiguration != null) {
            Properties containerDefinitionAsProperties = chameleonTargetConfiguration.getContainerDefinitionAsProperties();
            Path tempDirectory = Files.createTempDirectory("chameleonContainer", new FileAttribute[0]);
            Path arquillianPath = tempDirectory.resolve(ARQUILLIAN_PROPERTIES);
            containerDefinitionAsProperties.store(new FileWriter(arquillianPath.toFile()), "");
            return arquillianPath;
        }
        return null;
    }

    public Path generateNewArquillianXml(Class<?> testClass) throws IOException, TransformerException {
        ChameleonTargetConfiguration chameleonTargetConfiguration = this.findChameleonTargetConfiguration(testClass);
        if (chameleonTargetConfiguration != null) {
            Node containerDefinition = chameleonTargetConfiguration.getContainerDefinitionAsXml();
            Document arquillianConfigurationDocument = DomManipulation.createDocumentFromTemplate();
            return this.generate(arquillianConfigurationDocument, containerDefinition, ARQUILLIAN_XML);
        }
        return null;
    }

    public Path generateAppendedArquillianXml(Class<?> testClass, InputStream originalArquillianXml) throws IOException, TransformerException {
        ChameleonTargetConfiguration chameleonTargetConfiguration = this.findChameleonTargetConfiguration(testClass);
        if (chameleonTargetConfiguration != null) {
            Node containerDefinition = chameleonTargetConfiguration.getContainerDefinitionAsXml();
            Document arquillianConfigurationDocument = DomManipulation.createDocumentFromInputStream(originalArquillianXml);
            return this.generate(arquillianConfigurationDocument, containerDefinition, ARQUILLIAN_CHAMELEON_XML);
        }
        return null;
    }

    private Path generate(Document arquillianConfigurationDocument, Node containerDefinition, String filename) throws IOException, TransformerException {
        Element arquillianElement = (Element)arquillianConfigurationDocument.getFirstChild();
        Node importNode = arquillianConfigurationDocument.importNode(containerDefinition, true);
        arquillianElement.appendChild(importNode);
        Path tempDirectory = Files.createTempDirectory("chameleonContainer", new FileAttribute[0]);
        Path arquillianPath = tempDirectory.resolve(filename);
        DomManipulation.writeToPath(arquillianConfigurationDocument, arquillianPath);
        return arquillianPath;
    }

    private ChameleonTargetConfiguration findChameleonTargetConfiguration(Class<?> testClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = testClass.getAnnotations()) {
            ChameleonTargetConfiguration chameleonTargetConfiguration = AnnotationExtractor.extract(annotation);
            if (chameleonTargetConfiguration == null) continue;
            return chameleonTargetConfiguration;
        }
        return null;
    }
}

