/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.runner;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.arquillian.container.chameleon.runner.ArquillianChameleonConfigurationGenerator;

public class ArquillianChameleonConfigurator {
    private static final Logger log = Logger.getLogger(ArquillianChameleonConfigurator.class.getName());
    public static final String ARQUILLIAN_XML_SYS_PROPERTY = "arquillian.xml";

    public Path setup(Class<?> testClass, ClassLoader parent) throws IOException, TransformerException {
        Path arquillianChameleonConfiguration;
        InputStream configurationProperties = parent.getResourceAsStream("arquillian.properties");
        ArquillianChameleonConfigurationGenerator arquillianChameleonConfigurationGenerator = new ArquillianChameleonConfigurationGenerator();
        if (this.isArquillianConfiguredWithProperties(configurationProperties)) {
            configurationProperties.close();
            InputStream configurationXml = this.getArquillianXmlConfiguration(parent);
            if (this.isArquillianConfiguredWithXml(configurationXml)) {
                arquillianChameleonConfiguration = arquillianChameleonConfigurationGenerator.generateAppendedArquillianXml(testClass, configurationXml);
                System.setProperty(ARQUILLIAN_XML_SYS_PROPERTY, arquillianChameleonConfiguration.getFileName().toString());
                log.warning("Current project is configured with arquillian.properties and arquillian.xml. So we have created a custom arquillian filename and set it using a JVM System property. If you are planning to run tests in parallel in same JVM, this might cause some problems. We recommend to configure Arquillian either with .proeprties or .xml file approach but not both.");
            } else {
                arquillianChameleonConfiguration = arquillianChameleonConfigurationGenerator.generateNewArquillianXml(testClass);
            }
        } else {
            arquillianChameleonConfiguration = arquillianChameleonConfigurationGenerator.generateNewArquillianProperties(testClass);
        }
        return arquillianChameleonConfiguration;
    }

    private InputStream getArquillianXmlConfiguration(ClassLoader parent) {
        InputStream customXml;
        String customConfigurationXml = System.getProperty(ARQUILLIAN_XML_SYS_PROPERTY);
        if (customConfigurationXml != null && (customXml = parent.getResourceAsStream(customConfigurationXml)) != null) {
            return customXml;
        }
        InputStream configurationXml = parent.getResourceAsStream(ARQUILLIAN_XML_SYS_PROPERTY);
        if (configurationXml != null) {
            return configurationXml;
        }
        return null;
    }

    private boolean isArquillianConfiguredWithProperties(InputStream properties) {
        return properties != null;
    }

    private boolean isArquillianConfiguredWithXml(InputStream xml) {
        return xml != null;
    }
}

