/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.runner;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.arquillian.container.chameleon.api.ChameleonTarget;
import org.arquillian.container.chameleon.api.Mode;
import org.arquillian.container.chameleon.api.Property;
import org.arquillian.container.chameleon.runner.DomManipulation;
import org.arquillian.container.chameleon.runner.RunnerExpressionParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChameleonTargetConfiguration {
    private static final int CONTAINER = 0;
    public static final int VERSION = 1;
    public static final int MODE = 2;
    private String container;
    private String version;
    private Mode mode;
    private Map<String, String> customProperties = new HashMap<String, String>();

    protected ChameleonTargetConfiguration(String value) {
        String[] definition = value.split(":");
        if (definition.length != 3) {
            throw new IllegalArgumentException("Value of Chameleon expression must be of form container:version:mode. For example wildfly:9.0.0.Final:managed. Refer to https://github.com/arquillian/arquillian-container-chameleon#supported-containers for the complete list of supported containers.");
        }
        this.container = definition[0];
        this.version = definition[1];
        this.mode = Mode.valueOf((String)definition[2].toUpperCase());
    }

    protected ChameleonTargetConfiguration(String container, String version, Mode mode, Map<String, String> customProperties) {
        this.container = container;
        this.version = version;
        this.mode = mode;
        this.customProperties = customProperties;
    }

    public static ChameleonTargetConfiguration from(ChameleonTarget chameleonTarget) {
        if (ChameleonTargetConfiguration.isContainerNotDefinedAsString(chameleonTarget)) {
            return new ChameleonTargetConfiguration(RunnerExpressionParser.parseExpressions(chameleonTarget.container()), RunnerExpressionParser.parseExpressions(chameleonTarget.version()), Mode.valueOf((String)RunnerExpressionParser.parseExpressions(chameleonTarget.mode()).toUpperCase()), ChameleonTargetConfiguration.toMap(chameleonTarget.customProperties()));
        }
        ChameleonTargetConfiguration chameleonTargetConfiguration = new ChameleonTargetConfiguration(RunnerExpressionParser.parseExpressions(chameleonTarget.value()));
        chameleonTargetConfiguration.customProperties = ChameleonTargetConfiguration.toMap(chameleonTarget.customProperties());
        return chameleonTargetConfiguration;
    }

    private static boolean isContainerNotDefinedAsString(ChameleonTarget chameleonTarget) {
        return chameleonTarget.value().trim().isEmpty();
    }

    private static Map<String, String> toMap(Property[] properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Property property : properties) {
            map.put(property.name(), RunnerExpressionParser.parseExpressions(property.value()));
        }
        return map;
    }

    public ChameleonTargetConfiguration importConfiguration(ChameleonTargetConfiguration other) {
        if (this.container == null || this.container.isEmpty()) {
            this.container = other.getContainer();
        }
        if (this.version == null || this.version.isEmpty()) {
            this.version = other.getVersion();
        }
        if (this.mode == null) {
            this.mode = other.getMode();
        }
        Set<Map.Entry<String, String>> entries = other.getCustomProperties().entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (this.customProperties.containsKey(entry.getKey())) continue;
            this.customProperties.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Properties getContainerDefinitionAsProperties() {
        Properties properties = new Properties();
        properties.put("arq.container.chameleon.configuration.chameleonTarget", this.toChameleonTarget());
        properties.put("arq.container.chameleon.default", "true");
        this.updateCustomProperties(properties);
        return properties;
    }

    public Node getContainerDefinitionAsXml() {
        Document containerDocument = DomManipulation.createDocumentFromContainerTemplate();
        NodeList properties = containerDocument.getElementsByTagName("property");
        Element chameleonTargetProperty = this.findChameleonTargetProperty(properties);
        if (chameleonTargetProperty == null) {
            throw new IllegalArgumentException("No property chameleonTarget found in container template");
        }
        chameleonTargetProperty.setTextContent(this.toChameleonTarget());
        this.updateCustomProperties(containerDocument);
        return containerDocument.getFirstChild();
    }

    private void updateCustomProperties(Properties properties) {
        if (!this.customProperties.isEmpty()) {
            for (Map.Entry<String, String> customProperty : this.customProperties.entrySet()) {
                properties.put(String.format("arq.container.chameleon.configuration.%s", customProperty.getKey()), customProperty.getValue());
            }
        }
    }

    private void updateCustomProperties(Document containerDocument) {
        if (!this.customProperties.isEmpty()) {
            Element configuration = (Element)containerDocument.getElementsByTagName("configuration").item(0);
            for (Map.Entry<String, String> customProperty : this.customProperties.entrySet()) {
                Element customPropertyElement = containerDocument.createElement("property");
                customPropertyElement.setAttribute("name", customProperty.getKey());
                customPropertyElement.setTextContent(customProperty.getValue());
                configuration.appendChild(customPropertyElement);
            }
        }
    }

    private Element findChameleonTargetProperty(NodeList properties) {
        for (int i = 0; i < properties.getLength(); ++i) {
            Element property = (Element)properties.item(i);
            if (!property.hasAttribute("name") || !"chameleonTarget".equals(property.getAttribute("name"))) continue;
            return property;
        }
        return null;
    }

    public String getContainer() {
        return this.container;
    }

    public String getVersion() {
        return this.version;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public String toChameleonTarget() {
        return String.format("%s:%s:%s", this.container, this.version, this.mode.mode());
    }
}

