/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.runner;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DomManipulation {
    public static Document createDocumentFromInputStream(InputStream inputStream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(inputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException parserException) {
            throw new IllegalArgumentException(parserException);
        }
    }

    public static Document createDocumentFromTemplate() {
        return DomManipulation.createDocumentFromInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream("arquillian_template.xml"));
    }

    public static Document createDocumentFromContainerTemplate() {
        return DomManipulation.createDocumentFromInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream("container_template.xml"));
    }

    public static void writeToPath(Document document, Path file) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StreamResult output = new StreamResult(file.toFile());
        DOMSource input = new DOMSource(document);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(input, output);
    }
}

