/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon;

import java.util.HashMap;
import java.util.Map;
import org.arquillian.container.chameleon.ChameleonConfiguration;
import org.arquillian.container.chameleon.controller.DistributionController;
import org.arquillian.container.chameleon.controller.TargetController;
import org.arquillian.container.chameleon.spi.model.ContainerAdapter;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.threading.ExecutorService;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChameleonContainer
implements DeployableContainer<ContainerConfiguration> {
    private TargetController target;
    private DistributionController distribution;
    private ChameleonConfiguration configuration;
    private Map<String, String> originalContainerConfiguration;
    private Map<String, String> currentContainerConfiguration;
    @Inject
    private Instance<Injector> injectorInst;
    @Inject
    private Instance<ExecutorService> executorServiceInst;

    public Class<ContainerConfiguration> getConfigurationClass() {
        return this.target.getConfigurationClass();
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public boolean isInitiated() {
        return this.configuration != null;
    }

    Map<String, String> getOriginalContainerConfiguration() {
        return this.originalContainerConfiguration;
    }

    Map<String, String> getCurrentContainerConfiguration() {
        return this.currentContainerConfiguration;
    }

    public void init(ChameleonConfiguration configuration, ContainerDef targetConfiguration) {
        this.configuration = configuration;
        if (this.originalContainerConfiguration == null) {
            this.originalContainerConfiguration = new HashMap<String, String>(targetConfiguration.getContainerProperties());
        }
        try {
            ContainerAdapter adapter = configuration.getConfiguredAdapter();
            this.target = new TargetController(adapter, (Injector)this.injectorInst.get(), configuration.getChameleonResolveCacheFolder());
            this.distribution = new DistributionController(adapter, configuration.getChameleonDistributionDownloadFolder());
            this.distribution.setup(targetConfiguration, (ExecutorService)this.executorServiceInst.get());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not setup chameleon container", e);
        }
        this.currentContainerConfiguration = targetConfiguration.getContainerProperties();
    }

    public Class<?> resolveTargetClass(String className) throws ClassNotFoundException {
        if (this.isInitiated()) {
            return this.target.getClassLoader().loadClass(className);
        }
        throw new RuntimeException("Chameleon container is not yet initialized. No Classloader to load from");
    }

    public void setup(ContainerConfiguration targetConfiguration) {
        try {
            this.target.setup(targetConfiguration);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup Chameleon container for " + this.configuration.getChameleonTarget(), e);
        }
    }

    public void start() throws LifecycleException {
        this.target.start();
    }

    public void stop() throws LifecycleException {
        this.target.stop();
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        return this.target.deploy(archive);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.target.undeploy(archive);
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        this.target.deploy(descriptor);
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        this.target.undeploy(descriptor);
    }
}

