/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.arquillian.container.chameleon.Utils;
import org.arquillian.container.chameleon.controller.Resolver;
import org.arquillian.container.chameleon.spi.model.Container;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;

public class ContainerLoader {
    public Container[] load(InputStream containers, File cacheFolder) throws Exception {
        MavenDependency[] mavenDependencies = Utils.toMavenDependencies(new String[]{"org.yaml:snakeyaml:1.15"}, new String[0]);
        File[] archives = Resolver.resolve(cacheFolder, mavenDependencies);
        URLClassLoader classloader = new URLClassLoader(Utils.toURLs(archives), null);
        return this.loadContainers(classloader, containers);
    }

    private Container[] loadContainers(ClassLoader classloader, InputStream containers) throws Exception {
        Class<?> constructorClass = classloader.loadClass("org.yaml.snakeyaml.constructor.Constructor");
        Class<?> baseConstructorClass = classloader.loadClass("org.yaml.snakeyaml.constructor.BaseConstructor");
        Class<?> typeDescriptionClass = classloader.loadClass("org.yaml.snakeyaml.TypeDescription");
        Class<?> yamlClass = classloader.loadClass("org.yaml.snakeyaml.Yaml");
        Class<?> beanAccessClass = classloader.loadClass("org.yaml.snakeyaml.introspector.BeanAccess");
        Constructor<?> typeDescriptionConst = typeDescriptionClass.getConstructor(Class.class, String.class);
        Method addTypeDescription = constructorClass.getMethod("addTypeDescription", typeDescriptionClass);
        Method setBeanAccess = yamlClass.getDeclaredMethod("setBeanAccess", beanAccessClass);
        Method loadAs = yamlClass.getDeclaredMethod("loadAs", InputStream.class, Class.class);
        Object constructor = constructorClass.newInstance();
        addTypeDescription.invoke(constructor, typeDescriptionConst.newInstance(Container[].class, "tag:yaml.org,2002:" + Container[].class.getName()));
        Object yaml = yamlClass.getConstructor(baseConstructorClass).newInstance(constructor);
        Object fieldBeanAccess = null;
        for (Object beanAccess : beanAccessClass.getEnumConstants()) {
            if (!"FIELD".equals(beanAccess.toString())) continue;
            fieldBeanAccess = beanAccess;
            break;
        }
        setBeanAccess.invoke(yaml, fieldBeanAccess);
        return (Container[])loadAs.invoke(yaml, containers, Container[].class);
    }
}

