/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.arquillian.container.chameleon.ContainerLoader;
import org.arquillian.container.chameleon.FileUtils;
import org.arquillian.container.chameleon.spi.model.Container;
import org.arquillian.container.chameleon.spi.model.ContainerAdapter;
import org.arquillian.container.chameleon.spi.model.Target;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class ChameleonConfiguration
implements ContainerConfiguration {
    private static final String MAVEN_OUTPUT_DIRECTORY = "target";
    private static final String GRADLE_OUTPUT_DIRECTORY = "build";
    private static final String TMP_FOLDER_EXPRESSION = "TMP";
    private static final String DEFAULT_CONTAINER_MAPPING = "chameleon/default/containers.yaml";
    private String chameleonTarget = null;
    private String chameleonContainerConfigurationFile = null;
    private String chameleonDistributionDownloadFolder = null;
    private String chameleonResolveCacheFolder = null;

    public void validate() throws ConfigurationException {
        if (this.chameleonTarget == null) {
            throw new ConfigurationException("chameleonTarget must be provided in format server:version:type");
        }
        this.getChameleonContainerConfigurationFileStream();
        File resolveCache = this.getChameleonResolveCacheFolder();
        if (!resolveCache.exists() && !resolveCache.mkdirs()) {
            throw new ConfigurationException("Could not create all resolve cache folders: " + resolveCache);
        }
        this.getParsedTarget();
    }

    public String getChameleonTarget() {
        return this.chameleonTarget;
    }

    public void setChameleonTarget(String target) {
        this.chameleonTarget = target;
    }

    public String getChameleonContainerConfigurationFile() {
        return this.chameleonContainerConfigurationFile;
    }

    public void setChameleonContainerConfigurationFile(String containerConfigurationFile) {
        this.chameleonContainerConfigurationFile = containerConfigurationFile;
    }

    public InputStream getChameleonContainerConfigurationFileStream() {
        boolean isDefault = false;
        String resource = this.getChameleonContainerConfigurationFile();
        if (resource == null) {
            resource = DEFAULT_CONTAINER_MAPPING;
            isDefault = true;
        }
        return FileUtils.loadConfiguration((String)resource, (boolean)isDefault);
    }

    public String getChameleonDistributionDownloadFolder() {
        if (this.chameleonDistributionDownloadFolder != null) {
            if (TMP_FOLDER_EXPRESSION.equalsIgnoreCase(this.chameleonDistributionDownloadFolder)) {
                this.chameleonDistributionDownloadFolder = System.getProperty("java.io.tmpdir") + "/arquillian_chameleon";
            }
            return this.chameleonDistributionDownloadFolder;
        }
        return this.getOutputDirectory();
    }

    public void setChameleonDistributionDownloadFolder(String distributionDownloadFolder) {
        this.chameleonDistributionDownloadFolder = distributionDownloadFolder;
    }

    public File getChameleonResolveCacheFolder() {
        if (this.chameleonResolveCacheFolder != null) {
            return new File(this.chameleonResolveCacheFolder);
        }
        return new File(new File(this.getChameleonDistributionDownloadFolder(), "server"), "cache");
    }

    public void setChameleonResolveCacheFolder(String chameleonResolveCacheFolder) {
        this.chameleonResolveCacheFolder = chameleonResolveCacheFolder;
    }

    public ContainerAdapter getConfiguredAdapter() throws Exception {
        Container[] containers;
        Target target = this.getParsedTarget();
        for (Container container : containers = new ContainerLoader().load(this.getChameleonContainerConfigurationFileStream(), this.getChameleonResolveCacheFolder())) {
            ContainerAdapter adapter = container.matches(target);
            if (adapter == null) continue;
            return adapter;
        }
        throw new IllegalArgumentException("No container configuration found in " + this.getChameleonContainerConfigurationFile() + " for target " + this.getChameleonTarget());
    }

    private Target getParsedTarget() {
        return Target.from((String)this.getChameleonTarget());
    }

    private String getOutputDirectory() {
        if (Files.exists(Paths.get(GRADLE_OUTPUT_DIRECTORY, new String[0]), new LinkOption[0])) {
            return GRADLE_OUTPUT_DIRECTORY;
        }
        if (Files.exists(Paths.get(MAVEN_OUTPUT_DIRECTORY, new String[0]), new LinkOption[0])) {
            return MAVEN_OUTPUT_DIRECTORY;
        }
        return MAVEN_OUTPUT_DIRECTORY;
    }
}

