/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.ActivityManagerProvider;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.IdentifierGenerator;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.impl.DefaultActivityManagerProvider;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.container.spi.event.AndroidContainerStart;
import org.arquillian.droidium.container.spi.event.AndroidContainerStop;
import org.arquillian.droidium.container.spi.event.AndroidDeploy;
import org.arquillian.droidium.container.spi.event.AndroidDeviceReady;
import org.arquillian.droidium.container.spi.event.AndroidUndeploy;
import org.arquillian.droidium.container.utils.AndroidIdentifierGenerator;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class AndroidDeployableContainer
implements DeployableContainer<AndroidContainerConfiguration> {
    private static final Logger logger = Logger.getLogger(AndroidDeployableContainer.class.getSimpleName());
    @Inject
    @ContainerScoped
    private InstanceProducer<AndroidContainerConfiguration> configuration;
    @Inject
    @ContainerScoped
    private InstanceProducer<AndroidSDK> androidSDK;
    @Inject
    @ContainerScoped
    private InstanceProducer<IdentifierGenerator> idGenerator;
    @Inject
    @ContainerScoped
    private InstanceProducer<ProcessExecutor> executor;
    @Inject
    private Event<AndroidContainerStart> androidContainerStartEvent;
    @Inject
    private Event<AndroidContainerStop> androidContainerStopEvent;
    @Inject
    private Event<AndroidDeploy> deployArchiveEvent;
    @Inject
    private Event<AndroidUndeploy> undeployArchiveEvent;
    @Inject
    private Instance<AndroidDevice> androidDevice;
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public Class<AndroidContainerConfiguration> getConfigurationClass() {
        return AndroidContainerConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("android-protocol");
    }

    public void setup(AndroidContainerConfiguration configuration) {
        this.configuration.set((Object)configuration);
        this.androidSDK.set((Object)new AndroidSDK((AndroidContainerConfiguration)this.configuration.get()));
        this.idGenerator.set((Object)new AndroidIdentifierGenerator());
        this.executor.set((Object)new ProcessExecutor());
    }

    public void start() throws LifecycleException {
        logger.log(Level.INFO, "Starting the container {0}.", this.getContainerName());
        this.androidContainerStartEvent.fire((Object)new AndroidContainerStart());
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        this.deployArchiveEvent.fire((Object)new AndroidDeploy(archive));
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.undeployArchiveEvent.fire((Object)new AndroidUndeploy(archive));
    }

    public void stop() throws LifecycleException {
        logger.log(Level.INFO, "Stopping the container {0}.", this.getContainerName());
        this.androidContainerStopEvent.fire((Object)new AndroidContainerStop());
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Undeployment of a descriptor is not supported.");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Deployment of a descriptor is not supported");
    }

    public void onDeviceReady(@Observes AndroidDeviceReady event) {
        ActivityManagerProvider activityManagerProvider = this.getActivityManagerProvider();
        ((AndroidDevice)this.androidDevice.get()).setActivityManagerProvider(activityManagerProvider);
    }

    private ActivityManagerProvider getActivityManagerProvider() {
        return (ActivityManagerProvider)((ServiceLoader)this.serviceLoader.get()).onlyOne(ActivityManagerProvider.class, DefaultActivityManagerProvider.class);
    }

    private String getContainerName() {
        if (((AndroidContainerConfiguration)this.configuration.get()).getAvdName() == null) {
            if (((AndroidContainerConfiguration)this.configuration.get()).getSerialId() == null) {
                if (((AndroidContainerConfiguration)this.configuration.get()).getConsolePort() != null) {
                    return "running at port " + ((AndroidContainerConfiguration)this.configuration.get()).getConsolePort();
                }
                return "unsuccessful to determine container id";
            }
            return ((AndroidContainerConfiguration)this.configuration.get()).getSerialId();
        }
        return ((AndroidContainerConfiguration)this.configuration.get()).getAvdName();
    }
}

