/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidContainerConfigurationException;
import org.arquillian.droidium.container.configuration.Validate;

public class AndroidSDK {
    private AndroidContainerConfiguration configuration;
    private static final Logger logger = Logger.getLogger(AndroidSDK.class.getName());
    private static final String SOURCE_PROPERTIES_FILENAME = "source.properties";
    private static final String PLATFORM_VERSION_PROPERTY = "Platform.Version";
    private static final String API_LEVEL_PROPERTY = "AndroidVersion.ApiLevel";
    private static final String PLATFORMS_FOLDER_NAME = "platforms";
    private static final String PLATFORM_TOOLS_FOLDER_NAME = "platform-tools";
    private static final String BUILD_TOOLS_FOLDER_NAME = "build-tools";
    private final File sdkPath;
    private final File javaPath;
    private final Platform platform;
    private Set<Platform> availablePlatforms;

    public AndroidSDK(AndroidContainerConfiguration configuration) throws AndroidContainerConfigurationException {
        Validate.notNull(configuration, "AndroidSdk configuration must be provided");
        Validate.isReadableDirectory(configuration.getHome(), "Unable to read Android SDK from directory " + configuration.getHome());
        Validate.isReadableDirectory(configuration.getJavaHome(), "Unable to determine JAVA_HOME");
        Validate.notNullOrEmpty(configuration.getApiLevel(), "Platform or API level for Android SDK must be specified");
        this.sdkPath = new File(configuration.getHome());
        this.javaPath = new File(configuration.getJavaHome());
        this.availablePlatforms = this.findAvailablePlatforms();
        this.platform = this.findPlatformByApiLevel(configuration.getApiLevel());
        if (this.platform == null) {
            StringBuilder sb = new StringBuilder();
            for (Platform p : this.availablePlatforms) {
                sb.append("API level: ").append(p.apiLevel).append("(").append(p.name).append("), ");
            }
            if (sb.length() > 0) {
                sb.delete(sb.lastIndexOf(","), sb.length());
            }
            throw new AndroidContainerConfigurationException("Invalid SDK: API level " + configuration.getApiLevel() + " is not available. Available platforms are: " + sb.toString() + ". Use either Platform identification or API level in Arquillian configuration to identify your platform.");
        }
        this.configuration = configuration;
    }

    public AndroidContainerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AndroidContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    private Platform findPlatformByApiLevel(String apiLevel) {
        for (Platform p : this.availablePlatforms) {
            if (!p.apiLevel.equals(apiLevel)) continue;
            return p;
        }
        return null;
    }

    public Layout getLayout() throws AndroidContainerConfigurationException {
        Validate.isReadableDirectory(this.sdkPath, "Unable to read Android SDK from directory " + this.sdkPath);
        File platformTools = new File(this.sdkPath, PLATFORM_TOOLS_FOLDER_NAME);
        if (platformTools.exists() && platformTools.isDirectory()) {
            return Layout.LAYOUT_2_3;
        }
        File platforms = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        if (platforms.exists() && platforms.isDirectory()) {
            return Layout.LAYOUT_1_5;
        }
        throw new AndroidContainerConfigurationException("Android SDK could not be identified from path \"" + this.sdkPath + "\". ");
    }

    public String getPathForJavaTool(String tool) {
        String[] possiblePaths;
        for (String possiblePath : possiblePaths = new String[]{this.javaPath + "/bin/" + tool, this.javaPath + "/bin/" + tool + ".exe"}) {
            File file = new File(possiblePath);
            if (!file.exists() || file.isDirectory()) continue;
            return file.getAbsolutePath();
        }
        throw new RuntimeException("Could not find tool '" + tool + "'.Please ensure you've set JAVA_HOME environment " + "property properly and that it points to your Java installation directory.");
    }

    public String getPathForTool(String tool) {
        String[] possiblePaths;
        for (String possiblePath : possiblePaths = new String[]{this.sdkPath + "/" + PLATFORMS_FOLDER_NAME + "/" + tool, this.sdkPath + "/" + PLATFORMS_FOLDER_NAME + "/" + tool + ".exe", this.sdkPath + "/" + PLATFORMS_FOLDER_NAME + "/" + tool + ".bat", this.sdkPath + "/" + PLATFORMS_FOLDER_NAME + "/lib/" + tool, this.getPlatform() + "/tools/" + tool, this.getPlatform() + "/tools/" + tool + ".exe", this.getPlatform() + "/tools/" + tool + ".bat", this.getPlatform() + "/tools/lib/" + tool, this.sdkPath + "/tools/" + tool, this.sdkPath + "/tools/" + tool + ".exe", this.sdkPath + "/tools/" + tool + ".bat", this.sdkPath + "/tools/lib/" + tool, this.sdkPath + "/" + PLATFORM_TOOLS_FOLDER_NAME + "/" + tool}) {
            File file = new File(possiblePath);
            if (!file.exists() || file.isDirectory()) continue;
            return file.getAbsolutePath();
        }
        throw new RuntimeException("Could not find tool '" + tool + "'. Please ensure you've set it properly in Arquillian configuration");
    }

    private String getBuildTool(String tool) {
        File possiblePlatformPath = new File(this.sdkPath + "/" + PLATFORMS_FOLDER_NAME + this.getPlatform() + "/tools/" + tool);
        if (possiblePlatformPath.exists() && !possiblePlatformPath.isDirectory()) {
            return possiblePlatformPath.getAbsolutePath();
        }
        File possibleBuildPath = new File(this.sdkPath + "/" + BUILD_TOOLS_FOLDER_NAME);
        Object[] dirs = possibleBuildPath.listFiles();
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            File tmpTool = new File((File)dir, tool);
            if (!tmpTool.exists() || tmpTool.isDirectory()) continue;
            return tmpTool.getAbsolutePath();
        }
        throw new RuntimeException("Could not find tool '" + tool + ".");
    }

    public String getEmulatorPath() {
        return this.getPathForTool("emulator");
    }

    public String getMakeSdCardPath() {
        return this.getPathForTool("mksdcard");
    }

    public String getAdbPath() {
        return this.getPathForTool("adb");
    }

    public String getAaptPath() {
        return this.getBuildTool("aapt");
    }

    public String getAndroidPath() {
        return this.getPathForTool("android");
    }

    public String getPathForFrameworkAidl() throws AndroidContainerConfigurationException {
        Layout layout = this.getLayout();
        switch (layout) {
            case LAYOUT_1_5: 
            case LAYOUT_2_3: {
                return this.getPlatform() + "/framework.aidl";
            }
        }
        throw new AndroidContainerConfigurationException("Unsupported layout \"" + (Object)((Object)layout) + "\"!");
    }

    public File getPlatform() {
        Validate.isReadableDirectory(this.sdkPath, "Unable to read Android SDK from directory " + this.sdkPath);
        File platformsDirectory = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        Validate.isReadableDirectory(platformsDirectory, "Unable to read Android SDK Platforms directory from directory " + platformsDirectory);
        if (this.platform == null) {
            Object[] platformDirectories = platformsDirectory.listFiles();
            Arrays.sort(platformDirectories);
            return platformDirectories[platformDirectories.length - 1];
        }
        File platformDirectory = new File(this.platform.path);
        Validate.isReadableDirectory(platformsDirectory, "Unable to read Android SDK Platforms directory from directory " + platformsDirectory);
        return platformDirectory;
    }

    private Set<Platform> findAvailablePlatforms() throws AndroidContainerConfigurationException {
        ArrayList<Platform> availablePlatforms = new ArrayList<Platform>();
        List<File> platformDirectories = this.getPlatformDirectories();
        for (File pDir : platformDirectories) {
            File propFile = new File(pDir, SOURCE_PROPERTIES_FILENAME);
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propFile));
            }
            catch (IOException e) {
                throw new AndroidContainerConfigurationException("Unable to read platform directory details from its configuration file " + propFile.getAbsoluteFile());
            }
            if (!properties.containsKey(PLATFORM_VERSION_PROPERTY) || !properties.containsKey(API_LEVEL_PROPERTY)) continue;
            String platform = properties.getProperty(PLATFORM_VERSION_PROPERTY);
            String apiLevel = properties.getProperty(API_LEVEL_PROPERTY);
            Platform p = new Platform(platform, apiLevel, pDir.getAbsolutePath());
            availablePlatforms.add(p);
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Found available platform: " + p.toString());
        }
        Collections.sort(availablePlatforms);
        return new LinkedHashSet<Platform>(availablePlatforms);
    }

    private List<File> getPlatformDirectories() {
        File[] platformDirectories;
        ArrayList<File> sourcePropertyFiles = new ArrayList<File>();
        File platformsDirectory = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        Validate.isReadableDirectory(platformsDirectory, "Unable to read Android SDK Platforms directory from directory " + platformsDirectory);
        for (File file : platformDirectories = platformsDirectory.listFiles()) {
            if (!file.isDirectory() || !file.getName().startsWith("android-")) continue;
            sourcePropertyFiles.add(file);
        }
        return sourcePropertyFiles;
    }

    public static enum Layout {
        LAYOUT_1_5,
        LAYOUT_2_3;

    }

    private static final class Platform
    implements Comparable<Platform> {
        final String name;
        final String apiLevel;
        final String path;

        public Platform(String name, String apiLevel, String path) {
            this.name = name;
            this.apiLevel = apiLevel;
            this.path = path;
        }

        @Override
        public int compareTo(Platform o) {
            try {
                Integer current = Integer.parseInt(this.apiLevel);
                Integer other = Integer.parseInt(o.apiLevel);
                return current.compareTo(other);
            }
            catch (NumberFormatException e) {
                logger.log(Level.INFO, "Unable to compare platforms taking their api level as Integers, comparison as Strings follows");
                return this.apiLevel.compareTo(o.apiLevel);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.apiLevel == null ? 0 : this.apiLevel.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Platform other = (Platform)obj;
            if (this.apiLevel == null ? other.apiLevel != null : !this.apiLevel.equals(other.apiLevel)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Platform: ");
            sb.append(this.name).append("/API level ").append(this.apiLevel).append(" at ").append(this.path);
            return sb.toString();
        }
    }
}

