/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidBridge;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.impl.AndroidDeviceImpl;

public class AndroidBridgeImpl
implements AndroidBridge {
    private static final Logger logger = Logger.getLogger(AndroidBridgeImpl.class.getName());
    private AndroidDebugBridge delegate;
    private static final long ADB_TIMEOUT_MS = 60000L;
    private File adbLocation;
    private boolean forceNewBridge;

    AndroidBridgeImpl(File adbLocation, boolean forceNewBridge) throws IllegalArgumentException {
        Validate.isReadable(adbLocation, "ADB location does not represent a readable file: " + adbLocation);
        this.adbLocation = adbLocation;
        this.forceNewBridge = forceNewBridge;
    }

    public void connect() throws AndroidExecutionException {
        logger.info("Connecting to the Android Debug Bridge at " + this.adbLocation.getAbsolutePath() + " forceNewBridge = " + this.forceNewBridge);
        AndroidDebugBridge.initIfNeeded((boolean)true);
        this.delegate = AndroidDebugBridge.createBridge((String)this.adbLocation.getAbsolutePath(), (boolean)this.forceNewBridge);
        this.waitUntilConnected();
        this.waitForInitialDeviceList();
    }

    public boolean isConnected() {
        Validate.notNull(this.delegate, "Android debug bridge must be set. Please call connect() method before execution");
        return this.delegate.isConnected();
    }

    public void disconnect() throws AndroidExecutionException {
        Validate.notNull(this.delegate, "Android debug bridge must be set. Please call connect() method before execution");
        logger.info("Disconnecting Android Debug Bridge at " + this.adbLocation.getAbsolutePath());
        if (this.isConnected()) {
            logger.fine("\t Android Debug Bridge is connected.");
            if (!this.hasDevices()) {
                logger.fine("Android Debug Bridge does't have devices. Going to disconnect it.");
                AndroidDebugBridge.disconnectBridge();
                AndroidDebugBridge.terminate();
            } else {
                logger.fine("Android Debug Bridge has devices.");
                logger.info("There are still some devices on the Android Debug Bridge. Bridge will not be disconnected until none are connected.");
            }
        } else {
            logger.info("Android Debug Bridge is already disconnected.");
        }
    }

    public List<AndroidDevice> getDevices() {
        Validate.notNull(this.delegate, "Android debug bridge must be set. Please call connect() method before execution");
        IDevice[] idevices = this.delegate.getDevices();
        ArrayList<AndroidDevice> devices = new ArrayList<AndroidDevice>(idevices.length);
        for (IDevice d : idevices) {
            devices.add(new AndroidDeviceImpl(d));
        }
        return devices;
    }

    public List<AndroidDevice> getEmulators() {
        Validate.notNull(this.delegate, "Android debug bridge must be set. Please call connect() method before execution");
        ArrayList<AndroidDevice> emulators = new ArrayList<AndroidDevice>();
        for (AndroidDevice device : this.getDevices()) {
            if (!device.isEmulator()) continue;
            emulators.add(device);
        }
        return emulators;
    }

    public boolean hasDevices() {
        Validate.notNull(this.delegate, "Android debug bridge must be set. Please call connect() method before execution");
        return this.delegate.getDevices().length != 0;
    }

    private void waitUntilConnected() {
        for (int trials = 10; trials > 0; --trials) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.isConnected()) break;
        }
    }

    private void waitForInitialDeviceList() {
        if (!this.delegate.hasInitialDeviceList()) {
            logger.info("Waiting for initial device list from the Android Debug Bridge");
            long limitTime = System.currentTimeMillis() + 60000L;
            while (!this.delegate.hasInitialDeviceList() && System.currentTimeMillis() < limitTime) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for initial device list from Android Debug Bridge");
                }
            }
            if (!this.delegate.hasInitialDeviceList()) {
                logger.severe("Did not receive initial device list from the Android Debug Bridge.");
            }
        }
    }
}

