/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arquillian.droidium.container.api.AndroidBridge;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceSelector;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.api.IdentifierGenerator;
import org.arquillian.droidium.container.api.Screenshooter;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.impl.AndroidScreenshooter;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.container.spi.event.AndroidBridgeInitialized;
import org.arquillian.droidium.container.spi.event.AndroidDeviceReady;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceAvailable;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceCreate;
import org.arquillian.droidium.container.utils.IdentifierType;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidDeviceSelectorImpl
implements AndroidDeviceSelector {
    private static Logger logger = Logger.getLogger(AndroidDeviceSelectorImpl.class.getSimpleName());
    @Inject
    @ContainerScoped
    private InstanceProducer<AndroidDevice> androidDevice;
    @Inject
    @ContainerScoped
    private InstanceProducer<Screenshooter> screenshooter;
    @Inject
    private Instance<AndroidBridge> androidBridge;
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<ProcessExecutor> executor;
    @Inject
    private Instance<IdentifierGenerator> idGenerator;
    @Inject
    private Event<AndroidVirtualDeviceAvailable> androidVirtualDeviceAvailable;
    @Inject
    private Event<AndroidVirtualDeviceCreate> androidVirtualDeviceCreate;
    @Inject
    private Event<AndroidDeviceReady> androidDeviceReady;

    public void selectDevice(@Observes AndroidBridgeInitialized event) throws AndroidExecutionException {
        AndroidDevice device = null;
        if (this.isConnectingToPhysicalDevice() && (device = this.getPhysicalDevice()) != null) {
            this.setDronePorts(device);
            this.androidDevice.set((Object)device);
            this.screenshooter.set((Object)new AndroidScreenshooter(device));
            this.androidDeviceReady.fire((Object)new AndroidDeviceReady(device));
            return;
        }
        if (this.isConnectingToVirtualDevice() && (device = this.getVirtualDevice()) != null) {
            this.setDronePorts(device);
            this.androidDevice.set((Object)device);
            this.screenshooter.set((Object)new AndroidScreenshooter(device));
            this.androidDeviceReady.fire((Object)new AndroidDeviceReady(device));
            return;
        }
        if (((AndroidContainerConfiguration)this.configuration.get()).getAvdName() == null) {
            String generatedAvdName = ((IdentifierGenerator)this.idGenerator.get()).getIdentifier(((Object)((Object)IdentifierType.AVD)).getClass());
            ((AndroidContainerConfiguration)this.configuration.get()).setAvdName(generatedAvdName);
            ((AndroidContainerConfiguration)this.configuration.get()).setAvdGenerated(true);
        }
        if (!this.androidVirtualDeviceExists(((AndroidContainerConfiguration)this.configuration.get()).getAvdName())) {
            this.androidVirtualDeviceCreate.fire((Object)new AndroidVirtualDeviceCreate());
        } else {
            this.androidVirtualDeviceAvailable.fire((Object)new AndroidVirtualDeviceAvailable(((AndroidContainerConfiguration)this.configuration.get()).getAvdName()));
        }
    }

    private void setDronePorts(AndroidDevice device) {
        device.setDroneHostPort(((AndroidContainerConfiguration)this.configuration.get()).getDroneHostPort());
        device.setDroneGuestPort(((AndroidContainerConfiguration)this.configuration.get()).getDroneGuestPort());
    }

    private boolean isConnectingToVirtualDevice() {
        return this.isConsolePortDefined() || this.isAvdNameDefined();
    }

    private boolean isConnectingToPhysicalDevice() {
        String serialId = ((AndroidContainerConfiguration)this.configuration.get()).getSerialId();
        return serialId != null && !serialId.trim().isEmpty();
    }

    private boolean isConsolePortDefined() {
        String consolePort = ((AndroidContainerConfiguration)this.configuration.get()).getConsolePort();
        return consolePort != null && !consolePort.trim().equals("");
    }

    private boolean isAvdNameDefined() {
        String avdName = ((AndroidContainerConfiguration)this.configuration.get()).getAvdName();
        return avdName != null && !avdName.trim().equals("");
    }

    private boolean isOnlyConsolePortAvailable() {
        return this.isConsolePortDefined() && !this.isAvdNameDefined();
    }

    private boolean isOnlyAvdNameAvailable() {
        return this.isAvdNameDefined() && !this.isConsolePortDefined();
    }

    private AndroidDevice getVirtualDevice() throws AndroidExecutionException {
        String consolePort = ((AndroidContainerConfiguration)this.configuration.get()).getConsolePort();
        String avdName = ((AndroidContainerConfiguration)this.configuration.get()).getAvdName();
        if (this.isOnlyConsolePortAvailable()) {
            try {
                return this.getVirtualDeviceByConsolePort(consolePort);
            }
            catch (AndroidExecutionException ex) {
                return null;
            }
        }
        if (this.isOnlyAvdNameAvailable()) {
            try {
                return this.getVirtualDeviceByAvdName(avdName);
            }
            catch (AndroidExecutionException ex) {
                return null;
            }
        }
        try {
            return this.getVirtualDevice(consolePort, avdName);
        }
        catch (AndroidExecutionException ex) {
            return null;
        }
    }

    private AndroidDevice getVirtualDevice(String consolePort, String avdName) throws AndroidExecutionException {
        Validate.notNullOrEmpty(consolePort, "Console port to get emulator of is a null object or an empty string.");
        Validate.notNullOrEmpty(avdName, "AVD name to get emulator of is a null object or an empty string.");
        List devices = ((AndroidBridge)this.androidBridge.get()).getEmulators();
        if (devices == null || devices.size() == 0) {
            throw new AndroidExecutionException("There are no emulators on the Android bridge.");
        }
        for (AndroidDevice device : devices) {
            try {
                if (!device.getConsolePort().equals(consolePort) || !device.getAvdName().equals(avdName)) continue;
                return device;
            }
            catch (NullPointerException ex) {
                logger.severe("Unable to connect to the emulator. Please be sure you are running adb server.");
            }
        }
        return null;
    }

    private AndroidDevice getVirtualDeviceByConsolePort(String consolePort) throws AndroidExecutionException {
        Validate.notNullOrEmpty(consolePort, "Console port to get emulator of is a null object or an empty string.");
        List devices = ((AndroidBridge)this.androidBridge.get()).getEmulators();
        if (devices == null || devices.size() == 0) {
            throw new AndroidExecutionException("There are no emulators on the Android bridge.");
        }
        for (AndroidDevice device : devices) {
            String deviceConsolePort = device.getConsolePort();
            if (deviceConsolePort == null || !deviceConsolePort.equals(consolePort)) continue;
            return device;
        }
        throw new AndroidExecutionException("Unable to get Android emulator running on the console port " + consolePort);
    }

    private AndroidDevice getVirtualDeviceByAvdName(String avdName) throws AndroidExecutionException {
        Validate.notNullOrEmpty(avdName, "AVD name to get emulator of is a null object or an empty string");
        List devices = ((AndroidBridge)this.androidBridge.get()).getEmulators();
        if (devices == null || devices.size() == 0) {
            throw new AndroidExecutionException("There are no emulators on the Android bridge.");
        }
        for (AndroidDevice device : devices) {
            String deviceAvdName = device.getAvdName();
            if (deviceAvdName == null || !deviceAvdName.equals(avdName)) continue;
            return device;
        }
        throw new AndroidExecutionException("No running emulator of AVD name " + avdName + ".");
    }

    private AndroidDevice getPhysicalDevice() throws AndroidExecutionException {
        String serialId = ((AndroidContainerConfiguration)this.configuration.get()).getSerialId();
        List devices = ((AndroidBridge)this.androidBridge.get()).getDevices();
        if (devices == null || devices.size() == 0) {
            throw new AndroidExecutionException("There are no devices on the Android bridge.");
        }
        for (AndroidDevice device : devices) {
            if (device.isEmulator() || !serialId.equals(device.getSerialNumber())) continue;
            logger.info("Detected physical device with serial ID " + serialId + ".");
            return device;
        }
        throw new AndroidExecutionException("Unable to get device with serial ID " + serialId + ".");
    }

    private boolean androidVirtualDeviceExists(String avdName) throws AndroidExecutionException {
        ProcessExecutor executor = (ProcessExecutor)this.executor.get();
        Set<String> devices = this.getAndroidVirtualDeviceNames(executor);
        return devices.contains(avdName);
    }

    private Set<String> getAndroidVirtualDeviceNames(ProcessExecutor executor) throws AndroidExecutionException {
        List<String> output;
        Pattern deviceName = Pattern.compile("[\\s]*Name: ([^\\s]+)[\\s]*");
        HashSet<String> names = new HashSet<String>();
        try {
            output = executor.execute(((AndroidSDK)this.androidSDK.get()).getAndroidPath(), "list", "avd");
        }
        catch (InterruptedException e) {
            throw new AndroidExecutionException("Unable to get list of available AVDs", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new AndroidExecutionException("Unable to get list of available AVDs", (Throwable)e);
        }
        for (String line : output) {
            String name;
            Matcher m;
            if (!line.trim().startsWith("Name: ") || !(m = deviceName.matcher(line)).matches() || (name = m.group(1)) == null || name.trim().length() == 0) continue;
            names.add(name);
            logger.info("Available Android Device: " + name);
        }
        return names;
    }
}

