/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Command;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.impl.ProcessExecutor;
import org.arquillian.droidium.container.spi.event.AndroidSDCardCreate;
import org.arquillian.droidium.container.spi.event.AndroidSDCardDelete;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceAvailable;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceCreate;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceDelete;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceDeleted;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidVirtualDeviceManager {
    private static final Logger logger = Logger.getLogger(AndroidVirtualDeviceManager.class.getName());
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<ProcessExecutor> executor;
    @Inject
    private Event<AndroidVirtualDeviceAvailable> androidVirtualDeviceAvailable;
    @Inject
    private Event<AndroidVirtualDeviceDeleted> androidVirtualDeviceDeleted;
    @Inject
    private Event<AndroidSDCardDelete> androidSDCardDelete;
    @Inject
    private Event<AndroidSDCardCreate> androidSDCardCreate;

    public void deleteAndroidVirtualDevice(@Observes AndroidVirtualDeviceDelete event) {
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        try {
            ProcessExecutor executor = (ProcessExecutor)this.executor.get();
            Process android = this.constructDeleteProcess(executor, (AndroidSDK)this.androidSDK.get(), configuration.getAvdName());
            if (this.deleteAVD(android, executor) == 0) {
                logger.info("Android Virtual Device " + configuration.getAvdName() + " deleted.");
            } else {
                logger.info("Unable to delete Android Virtual Device " + configuration.getAvdName() + ".");
            }
        }
        catch (AndroidExecutionException ex) {
            logger.info("Unable to delete AVD - " + ex.getMessage());
        }
        this.androidSDCardDelete.fire((Object)new AndroidSDCardDelete());
        this.androidVirtualDeviceDeleted.fire((Object)new AndroidVirtualDeviceDeleted(configuration.getAvdName()));
    }

    public void createAndroidVirtualDevice(@Observes AndroidVirtualDeviceCreate event) throws AndroidExecutionException {
        Validate.notNulls(new Object[]{this.configuration.get(), this.androidSDK.get()}, "container configuration injection or Android SDK injection is null");
        this.androidSDCardCreate.fire((Object)new AndroidSDCardCreate());
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        AndroidSDK sdk = (AndroidSDK)this.androidSDK.get();
        Validate.notNullOrEmpty(configuration.getSdSize(), "Memory SD card size must be defined");
        ProcessExecutor executor = (ProcessExecutor)this.executor.get();
        try {
            Command command = new Command();
            command.add(sdk.getAndroidPath()).add("create").add("avd").add("-n").add(configuration.getAvdName()).add("-t").add("android-" + configuration.getApiLevel()).add("-f").add("-p").add(configuration.getGeneratedAvdPath() + System.getProperty("file.separator") + configuration.getAvdName());
            if (configuration.getSdCard() != null && new File(configuration.getSdCard()).exists()) {
                command.add("-c").add(configuration.getSdCard());
            } else {
                command.add("-c").add(configuration.getSdSize());
            }
            if (configuration.getAbi() != null) {
                command.add("--abi").add(configuration.getAbi());
            }
            logger.info("Creating new avd " + command);
            String[] argsArrays = new String[command.size()];
            executor.execute((Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("Do you wish to create a custom hardware profile [no]", "no" + System.getProperty("line.separator"));
                }
            }, command.getAsList().toArray(argsArrays));
            this.androidVirtualDeviceAvailable.fire((Object)new AndroidVirtualDeviceAvailable(configuration.getAvdName()));
        }
        catch (InterruptedException e) {
            throw new AndroidExecutionException("Unable to create a new AVD Device", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new AndroidExecutionException("Unable to create a new AVD Device", (Throwable)e);
        }
    }

    private Process constructDeleteProcess(ProcessExecutor executor, AndroidSDK androidSDK, String avdName) throws AndroidExecutionException {
        Command command = new Command();
        command.add(androidSDK.getAndroidPath()).add("delete").add("avd").add("-n").add(avdName);
        try {
            return executor.spawn(command.getAsList());
        }
        catch (InterruptedException e) {
            throw new AndroidExecutionException((Throwable)e, "Unable to delete AVD {0}.", new Object[]{avdName});
        }
        catch (ExecutionException e) {
            throw new AndroidExecutionException((Throwable)e, "Unable to delete AVD {0}.", new Object[]{avdName});
        }
    }

    private int deleteAVD(final Process android, ProcessExecutor executor) throws AndroidExecutionException {
        try {
            int deleted = executor.submit(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return android.waitFor();
                }
            }).get();
            return deleted;
        }
        catch (Exception ex) {
            throw new AndroidExecutionException((Throwable)ex);
        }
    }
}

