/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.impl.CountDownWatch;

public class ProcessExecutor {
    private final ShutDownThreadHolder shutdownThreads = new ShutDownThreadHolder();
    private final ExecutorService service = Executors.newCachedThreadPool();
    private final ScheduledExecutorService scheduledService = Executors.newScheduledThreadPool(1);

    public <T> Future<T> submit(Callable<T> callable) {
        return this.service.submit(callable);
    }

    public Boolean scheduleUntilTrue(Callable<Boolean> callable, long timeout, long step, TimeUnit unit) throws InterruptedException, ExecutionException {
        CountDownWatch countdown = new CountDownWatch(timeout, unit);
        while (countdown.timeLeft() > 0L) {
            ScheduledFuture<Boolean> future = this.scheduledService.schedule(callable, step, unit);
            Boolean result = false;
            try {
                result = (Boolean)future.get(countdown.timeLeft(), unit);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (TimeoutException e) {
            }
        }
        return false;
    }

    public Process spawn(List<String> command) throws InterruptedException, ExecutionException {
        return this.spawn(command.toArray(new String[0]));
    }

    public Process spawn(String ... command) throws InterruptedException, ExecutionException {
        Future<Process> processFuture = this.service.submit(new SpawnedProcess(true, command));
        Process process = processFuture.get();
        this.service.submit(new ProcessOutputConsumer(new ProcessWithId(process, command[0])));
        this.shutdownThreads.addHookFor(process);
        return process;
    }

    public List<String> execute(Map<String, String> input, String ... command) throws InterruptedException, ExecutionException {
        Future<Process> processFuture = this.service.submit(new SpawnedProcess(true, command));
        Process process = processFuture.get();
        return this.service.submit(new ProcessOutputConsumer(new ProcessWithId(process, command[0]), input)).get();
    }

    public List<String> execute(String ... command) throws InterruptedException, ExecutionException {
        return this.execute(Collections.<String, String>emptyMap(), command);
    }

    public ProcessExecutor removeShutdownHook(Process p) {
        this.shutdownThreads.removeHookFor(p);
        return this;
    }

    private class ProcessWithId
    extends Process {
        private final Process process;
        private final String id;

        public ProcessWithId(Process process, String id) {
            this.id = id;
            this.process = process;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.process.getOutputStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.process.getInputStream();
        }

        @Override
        public InputStream getErrorStream() {
            return this.process.getErrorStream();
        }

        @Override
        public int waitFor() throws InterruptedException {
            return this.process.waitFor();
        }

        @Override
        public int exitValue() {
            return this.process.exitValue();
        }

        @Override
        public void destroy() {
            this.process.destroy();
        }

        public String toString() {
            return "Process: " + this.id;
        }
    }

    private static class ProcessOutputConsumer
    implements Callable<List<String>> {
        private static final Logger log = Logger.getLogger(ProcessOutputConsumer.class.getName());
        private static final String NL = System.getProperty("line.separator");
        private final Process process;
        private final Map<String, String> inputOutputMap;

        public ProcessOutputConsumer(ProcessWithId process, Map<String, String> inputOutputMap) {
            this.process = process;
            this.inputOutputMap = inputOutputMap;
        }

        public ProcessOutputConsumer(ProcessWithId process) {
            this(process, Collections.emptyMap());
        }

        @Override
        public List<String> call() throws Exception {
            InputStream stream = this.process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            ArrayList<String> output = new ArrayList<String>();
            try {
                int i;
                StringBuilder line = new StringBuilder();
                while ((i = reader.read()) != -1) {
                    char c = (char)i;
                    line.append(c);
                    String key = line.toString();
                    if (this.inputOutputMap.containsKey(key)) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "{0} outputs: {1}, responded with: ", new Object[]{this.process, line.toString(), this.inputOutputMap.get(key)});
                        }
                        OutputStream ostream = this.process.getOutputStream();
                        ostream.write(this.inputOutputMap.get(key).getBytes());
                        ostream.flush();
                    }
                    if (line.indexOf("\n") == -1 && line.indexOf(NL) == -1) continue;
                    String wholeLine = line.toString();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0} outputs: {1}", new Object[]{this.process, wholeLine});
                    } else if (wholeLine.toLowerCase().startsWith("error")) {
                        log.log(Level.SEVERE, "{0} outputs: {1}", new Object[]{this.process, wholeLine});
                    }
                    output.add(wholeLine);
                    line = new StringBuilder();
                }
                if (line.length() > 1) {
                    String wholeLine = line.toString();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0} outputs: {1}", new Object[]{this.process, wholeLine});
                    } else if (wholeLine.toLowerCase().startsWith("error")) {
                        log.log(Level.SEVERE, "{0} outputs: {1}", new Object[]{this.process, wholeLine});
                    }
                    output.add(wholeLine);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return output;
        }
    }

    private static class SpawnedProcess
    implements Callable<Process> {
        private final String[] command;
        private boolean redirectErrorStream;

        public SpawnedProcess(boolean redirectErrorStream, String ... command) {
            this.redirectErrorStream = redirectErrorStream;
            this.command = command;
        }

        @Override
        public Process call() throws Exception {
            ProcessBuilder builder = new ProcessBuilder(InputSanitizer.sanitizeArguments(this.command));
            builder.redirectErrorStream(this.redirectErrorStream);
            return builder.start();
        }
    }

    private static class InputSanitizer {
        private InputSanitizer() {
        }

        public static List<String> sanitizeArguments(String ... command) {
            ArrayList<String> cmd = new ArrayList<String>(command.length);
            for (String c : command) {
                if (c == null || c.length() <= 0) continue;
                cmd.add(c);
            }
            return cmd;
        }
    }

    private static class ShutDownThreadHolder {
        private final Map<Process, Thread> shutdownThreads = Collections.synchronizedMap(new HashMap());

        public void addHookFor(final Process p) {
            Thread shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (p != null) {
                        p.destroy();
                        try {
                            p.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(shutdownThread);
            this.shutdownThreads.put(p, shutdownThread);
        }

        public void removeHookFor(Process p) {
            this.shutdownThreads.remove(p);
        }
    }
}

