/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.utils;

import java.util.UUID;
import org.arquillian.droidium.container.api.IdentifierGenerator;
import org.arquillian.droidium.container.api.IdentifierGeneratorException;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.utils.IdentifierType;

public class AndroidIdentifierGenerator
implements IdentifierGenerator {
    private String sdCardSuffix = ".img";

    public String getIdentifier(Class<?> identifierType) {
        String uuid = UUID.randomUUID().toString();
        if (identifierType.isInstance((Object)IdentifierType.AVD)) {
            return uuid;
        }
        if (identifierType.isInstance((Object)IdentifierType.SD_CARD)) {
            return uuid + this.sdCardSuffix;
        }
        if (identifierType.isInstance((Object)IdentifierType.SD_CARD_LABEL)) {
            return uuid;
        }
        throw new IdentifierGeneratorException("Not possible to generate any identifier of type " + identifierType.getName());
    }

    public AndroidIdentifierGenerator setSdCardSuffix(String suffix) {
        Validate.notNullOrEmpty(suffix, "suffix to set for SD card can not be a null object nor an empty string.");
        if (!suffix.startsWith(".")) {
            this.sdCardSuffix = "." + suffix;
        }
        return this;
    }
}

