/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.utils;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;

public class LogcatHelper {
    private static final Logger logger = Logger.getLogger(LogcatHelper.class.getName());
    private AndroidContainerConfiguration configuration;
    private AndroidDevice androidDevice;

    public LogcatHelper(AndroidContainerConfiguration configuration, AndroidDevice androidDevice) {
        this.configuration = configuration;
        this.androidDevice = androidDevice;
    }

    public Writer prepareWriter() {
        if (this.configuration.getLogtype().equals("output")) {
            String prefix = this.configuration.isLogSerialId() ? "LOGCAT (" + this.androidDevice.getSerialNumber() + "): " : "LOGCAT: ";
            return new LogcatToConsoleWriter(prefix);
        }
        if (this.configuration.getLogtype().equals("logger")) {
            String name = this.configuration.isLogSerialId() ? "LOGCAT (" + this.androidDevice.getSerialNumber() + ")" : "LOGCAT";
            return new LogcatToLoggerWriter(Logger.getLogger(name));
        }
        if (this.configuration.getLogtype().equals("file")) {
            String logPath = this.configuration.getLogFilePath();
            if (this.configuration.isLogSerialId()) {
                String[] logPathParts = logPath.split(".");
                if (logPathParts.length > 1) {
                    logPath = "";
                    for (int i = 0; i < logPathParts.length - 1; ++i) {
                        logPath = logPath + logPathParts[i];
                    }
                    logPath = logPath + this.androidDevice.getSerialNumber();
                    logPath = logPath + logPathParts[logPathParts.length - 1];
                } else {
                    logPath = logPath + this.androidDevice.getSerialNumber();
                }
            }
            try {
                return new LogcatToFileWriter(logPath);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Couldn't open log file!", e);
                return null;
            }
        }
        return null;
    }

    public AndroidContainerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AndroidContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    public AndroidDevice getAndroidDevice() {
        return this.androidDevice;
    }

    public void setAndroidDevice(AndroidDevice androidDevice) {
        this.androidDevice = androidDevice;
    }

    public class LogcatToFileWriter
    extends FileWriter {
        public LogcatToFileWriter(String fileName) throws IOException {
            super(fileName);
        }

        @Override
        public void write(String str) throws IOException {
            super.write(str + "\n");
        }
    }

    public class LogcatToLoggerWriter
    extends Writer {
        private Logger logger;

        public LogcatToLoggerWriter(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            String line = String.copyValueOf(cbuf, off, len);
            if (line.startsWith("E")) {
                this.logger.severe(line);
            } else if (line.startsWith("W")) {
                this.logger.warning(line);
            } else if (line.startsWith("I")) {
                this.logger.info(line);
            } else if (line.startsWith("D")) {
                this.logger.config(line);
            } else if (line.startsWith("V")) {
                this.logger.fine(line);
            } else {
                this.logger.finer(line);
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    public class LogcatToConsoleWriter
    extends Writer {
        private String prefix;

        public LogcatToConsoleWriter() {
            this("LOGCAT: ");
        }

        public LogcatToConsoleWriter(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            String line = String.copyValueOf(cbuf, off, len);
            System.out.println(this.prefix + line);
        }

        @Override
        public void flush() throws IOException {
            System.out.flush();
        }

        @Override
        public void close() throws IOException {
            System.out.flush();
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }
}

