/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.liferay.maven.internal;

import java.io.File;
import java.util.Map;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.AbstractPackagingPluginConfiguration;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiferayPluginConfiguration
extends AbstractPackagingPluginConfiguration {
    final Logger log = LoggerFactory.getLogger(LiferayPluginConfiguration.class);
    public static final String LIFERAY_PLUGIN_GA = "com.liferay.maven.plugins:liferay-maven-plugin";
    private String appServerClassesPortalDir;
    private String appServerLibGlobalDir;
    private String appServerPortalDir;
    private String appServerLibPortalDir;
    private String appServerTldPortalDir;
    private String liferayVersion;
    private String pluginType;
    private String autoDeployDir;
    private String appServerDeployDir;
    private String destDir;
    private String baseDir;
    private String appServerType = "tomcat";
    private boolean customPortletXml;
    private File directDeployArchive;

    public LiferayPluginConfiguration(ParsedPomFile pomFile) {
        super(pomFile);
        Map configValues = pomFile.getPluginConfiguration(LIFERAY_PLUGIN_GA);
        this.log.trace("Liferay Plugin Configuration:" + configValues);
        this.appServerLibGlobalDir = (String)configValues.get("appServerLibGlobalDir");
        if (Validate.isNullOrEmpty((String)this.appServerLibGlobalDir)) {
            throw new RuntimeException("Please configure 'appServerLibGlobalDir' in maven liferay plugin");
        }
        this.appServerPortalDir = (String)configValues.get("appServerPortalDir");
        if (Validate.isNullOrEmpty((String)this.appServerPortalDir)) {
            throw new RuntimeException("Please configure 'appServerPortalDir' in maven liferay plugin");
        }
        this.appServerClassesPortalDir = (String)configValues.get("appServerClassesPortalDir");
        if (Validate.isNullOrEmpty((String)this.appServerClassesPortalDir)) {
            this.appServerClassesPortalDir = this.appServerPortalDir + "/WEB-INF/classes";
        }
        this.appServerLibPortalDir = (String)configValues.get("appServerLibPortalDir");
        if (Validate.isNullOrEmpty((String)this.appServerLibPortalDir)) {
            this.appServerLibPortalDir = this.appServerPortalDir + "/WEB-INF/lib";
        }
        this.appServerTldPortalDir = (String)configValues.get("appServerTldPortalDir");
        if (Validate.isNullOrEmpty((String)this.appServerTldPortalDir)) {
            this.appServerTldPortalDir = this.appServerPortalDir + "/WEB-INF/tld";
        }
        this.liferayVersion = (String)configValues.get("liferayVersion");
        if (Validate.isNullOrEmpty((String)this.liferayVersion)) {
            throw new RuntimeException("Please configure 'liferayVersion' in maven liferay plugin");
        }
        this.pluginType = (String)configValues.get("pluginType");
        this.autoDeployDir = (String)configValues.get("autoDeployDir");
        this.appServerDeployDir = (String)configValues.get("appServerDeployDir");
        this.customPortletXml = new Boolean((String)configValues.get("customPortletXml"));
        this.baseDir = pomFile.getBuildOutputDirectory().getAbsolutePath();
        this.destDir = pomFile.getBuildOutputDirectory().getAbsolutePath() + "/..";
        this.directDeployArchive = new File(pomFile.getBuildOutputDirectory(), pomFile.getFinalName());
    }

    public String getAppServerClassesPortalDir() {
        return this.appServerClassesPortalDir;
    }

    public String getAppServerLibGlobalDir() {
        return this.appServerLibGlobalDir;
    }

    public String getAppServerPortalDir() {
        return this.appServerPortalDir;
    }

    public String getAppServerLibPortalDir() {
        return this.appServerLibPortalDir;
    }

    public String getAppServerTldPortalDir() {
        return this.appServerTldPortalDir;
    }

    public String getLiferayVersion() {
        return this.liferayVersion;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public String getAutoDeployDir() {
        return this.autoDeployDir;
    }

    public String getAppServerDeployDir() {
        return this.appServerDeployDir;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getPluginGA() {
        return LIFERAY_PLUGIN_GA;
    }

    public String[] getIncludes() {
        return new String[0];
    }

    public String[] getExcludes() {
        return new String[0];
    }

    public String getAppServerType() {
        return this.appServerType;
    }

    public File getDirectDeployArchive() {
        return this.directDeployArchive;
    }

    public boolean isCustomPortletXml() {
        return this.customPortletXml;
    }
}

