/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.liferay.maven.internal.tasks;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.apache.commons.io.FileUtils;
import org.arquillian.liferay.maven.internal.LiferayPluginConfiguration;
import org.jboss.shrinkwrap.resolver.api.ResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.AcceptAllStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.task.MavenWorkingSessionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ToolsClasspathTask implements MavenWorkingSessionTask<URLClassLoader>
{
    INSTANCE;


    public URLClassLoader execute(MavenWorkingSession session) {
        Logger log = LoggerFactory.getLogger(ToolsClasspathTask.class);
        ParsedPomFile pomFile = session.getParsedPomFile();
        LiferayPluginConfiguration configuration = new LiferayPluginConfiguration(pomFile);
        System.setProperty("liferayVersion", configuration.getLiferayVersion());
        File appServerLibGlobalDir = new File(configuration.getAppServerLibGlobalDir());
        File appServerLibPortalDir = new File(configuration.getAppServerLibPortalDir());
        ArrayList<URI> liferayToolArchives = new ArrayList<URI>();
        if (appServerLibGlobalDir != null && appServerLibGlobalDir.exists()) {
            Collection appServerLibs = FileUtils.listFiles((File)appServerLibGlobalDir, (String[])new String[]{"jar"}, (boolean)true);
            for (Object file : appServerLibs) {
                liferayToolArchives.add(((File)file).toURI());
            }
            Collection liferayPortalLibs = FileUtils.listFiles((File)appServerLibPortalDir, (String[])new String[]{"jar"}, (boolean)true);
            for (File file : liferayPortalLibs) {
                liferayToolArchives.add(file.toURI());
            }
            File[] utilJars = ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromClassLoaderResource("liferay-tool-deps.xml")).importCompileAndRuntimeDependencies()).resolve()).using((ResolutionStrategy)AcceptAllStrategy.INSTANCE)).asFile();
            for (int i = 0; i < utilJars.length; ++i) {
                liferayToolArchives.add(utilJars[i].toURI());
            }
        }
        log.trace("Jars count in Tools classpath Archive:" + liferayToolArchives.size());
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        try {
            if (!liferayToolArchives.isEmpty()) {
                ListIterator toolsJarItr = liferayToolArchives.listIterator();
                while (toolsJarItr.hasNext()) {
                    URI jarURI = (URI)toolsJarItr.next();
                    classpathUrls.add(jarURI.toURL());
                }
            }
        }
        catch (MalformedURLException e) {
            log.error("Error building Tools classpath", (Throwable)e);
        }
        return new URLClassLoader(classpathUrls.toArray(new URL[classpathUrls.size()]), null);
    }
}

