/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.liferay.maven.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.test.impl.client.deployment.AnnotationDeploymentScenarioGenerator;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.archive.importer.MavenImporter;
import org.jboss.shrinkwrap.resolver.api.maven.archive.importer.PomlessMavenImporter;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDeploymentScenarioGenerator
extends AnnotationDeploymentScenarioGenerator {
    private static final Logger log = LoggerFactory.getLogger(MavenDeploymentScenarioGenerator.class);
    @Inject
    private Instance<ArquillianDescriptor> descriptor;

    public List<DeploymentDescription> generate(TestClass testClass) {
        this.containerDef();
        ArrayList<DeploymentDescription> descriptions = super.generate(testClass);
        if (descriptions == null) {
            descriptions = new ArrayList<DeploymentDescription>();
        }
        log.info("Generating Deployment for Liferay Plugin ");
        DeploymentDescription deploymentDecription = this.createLiferayPluginDeployment();
        if (deploymentDecription != null) {
            descriptions.add(deploymentDecription);
        }
        return descriptions;
    }

    private ContainerDef containerDef() {
        List containers = ((ArquillianDescriptor)this.descriptor.get()).getContainers();
        ContainerDef defaultContainer = null;
        for (int i = 0; i < containers.size(); ++i) {
            defaultContainer = (ContainerDef)containers.get(i);
            if (!defaultContainer.isDefault()) continue;
            String containerName = defaultContainer.getContainerName();
            Validate.notNullOrEmpty((String)containerName, (String)"At least one default container must be defined in arquillian.xml");
            if (containerName.contains("tomcat")) {
                System.setProperty("appServerType", "tomcat");
            } else if (containerName.contains("jboss")) {
                System.setProperty("appServerType", "jboss");
            }
            return defaultContainer;
        }
        return null;
    }

    private DeploymentDescription createLiferayPluginDeployment() {
        log.debug("Building Liferay Plugin from project pom.xml");
        File pomFile = new File("pom.xml");
        if (pomFile != null && pomFile.exists()) {
            log.debug("Loading project from pom file:" + pomFile.getAbsolutePath());
            String globalSettings = System.getProperty("maven.execution.global-settings");
            String userSettings = System.getProperty("maven.execution.user-settings");
            String profilesString = System.getProperty("maven.execution.active-profiles");
            PomlessMavenImporter mavenImporter = (PomlessMavenImporter)ShrinkWrap.create(MavenImporter.class);
            if (globalSettings != null) {
                mavenImporter = ((MavenImporter)mavenImporter).configureFromFile(globalSettings);
            }
            if (userSettings != null) {
                mavenImporter = ((MavenImporter)mavenImporter).configureFromFile(userSettings);
            }
            String[] profiles = new String[]{};
            if (profilesString != null) {
                profiles = profilesString.split(",");
            }
            WebArchive archive = (WebArchive)mavenImporter.loadPomFromFile(pomFile, profiles).importBuildOutput().as(WebArchive.class);
            DeploymentDescription deploymentDescription = new DeploymentDescription("_DEFAULT", (Archive)archive);
            deploymentDescription.shouldBeTestable(true);
            return deploymentDescription;
        }
        return null;
    }
}

