/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.liferay.maven.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.arquillian.liferay.maven.internal.LiferayPluginConfiguration;
import org.arquillian.liferay.maven.internal.tasks.HookDeployerTask;
import org.arquillian.liferay.maven.internal.tasks.PortletDeployerTask;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.formatter.Formatters;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.archive.importer.MavenImporterException;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.api.maven.pom.Resource;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.AbstractCompilingProcessor;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.ArchiveFilteringUtils;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.WarPluginConfiguration;
import org.jboss.shrinkwrap.resolver.impl.maven.task.AddAllDeclaredDependenciesTask;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiferayWarPackagingProcessor
extends AbstractCompilingProcessor<WebArchive>
implements PackagingProcessor<WebArchive> {
    private static final Logger log = LoggerFactory.getLogger(LiferayWarPackagingProcessor.class);
    private WebArchive archive;

    public LiferayWarPackagingProcessor configure(Archive<?> originalArchive, MavenWorkingSession session) {
        super.configure(session);
        this.archive = (WebArchive)ShrinkWrap.create(WebArchive.class);
        return this;
    }

    public WebArchive getResultingArchive() {
        log.trace("Resulting Archive:" + this.archive.toString((Formatter)Formatters.VERBOSE));
        return this.archive;
    }

    public boolean handles(PackagingType packagingType) {
        return PackagingType.WAR.equals((Object)packagingType);
    }

    public LiferayWarPackagingProcessor importBuildOutput(MavenResolutionStrategy strategy) {
        log.debug("Building Liferay Plugin Archive");
        ParsedPomFile pomFile = this.session.getParsedPomFile();
        if (Validate.isReadable((File)pomFile.getSourceDirectory())) {
            this.compile(pomFile.getSourceDirectory(), pomFile.getBuildOutputDirectory(), new ScopeType[]{ScopeType.COMPILE, ScopeType.RUNTIME, ScopeType.SYSTEM, ScopeType.IMPORT, ScopeType.PROVIDED});
            JavaArchive classes = (JavaArchive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"webinf_clases.jar")).importDirectory(pomFile.getBuildOutputDirectory()).as(JavaArchive.class);
            this.archive = (WebArchive)this.archive.merge((Archive)classes, ArchivePaths.create((String)"WEB-INF/classes"));
            log.trace("Removing temp file: " + pomFile.getFinalName() + " form archive");
            this.archive.delete(ArchivePaths.create((String)"WEB-INF/classes", (String)pomFile.getFinalName()));
        }
        for (Resource resource : pomFile.getResources()) {
            this.archive.addAsResource(resource.getSource(), resource.getTargetPath());
        }
        WarPluginConfiguration warPluginConfiguration = new WarPluginConfiguration(pomFile);
        if (Validate.isReadable((File)warPluginConfiguration.getWarSourceDirectory())) {
            WebArchive webapp = (WebArchive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"webapp.war")).importDirectory(warPluginConfiguration.getWarSourceDirectory(), this.applyFilter(warPluginConfiguration)).as(WebArchive.class);
            this.archive.merge((Archive)webapp);
        }
        try {
            Manifest manifest = warPluginConfiguration.getArchiveConfiguration().asManifest();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            manifest.write(bout);
            this.archive.setManifest((Asset)new StringAsset(bout.toString()));
        }
        catch (MavenImporterException e) {
            log.error("Error adding manifest", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Error adding manifest", (Throwable)e);
        }
        this.session = AddAllDeclaredDependenciesTask.INSTANCE.execute(this.session);
        Collection artifacts = this.session.resolveDependencies(strategy);
        for (MavenResolvedArtifact artifact : artifacts) {
            this.archive.addAsLibrary(artifact.asFile());
        }
        this.archive = (WebArchive)ArchiveFilteringUtils.filterArchiveContent((Archive)this.archive, WebArchive.class, (String[])warPluginConfiguration.getIncludes(), (String[])warPluginConfiguration.getExcludes());
        LiferayPluginConfiguration liferayPluginConfiguration = new LiferayPluginConfiguration(pomFile);
        String baseDirPath = liferayPluginConfiguration.getBaseDir();
        File tempDestFile = new File(baseDirPath, pomFile.getFinalName());
        File baseDir = new File(baseDirPath);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
            log.info("Created dir " + baseDir);
        }
        log.trace("Temp Archive:" + tempDestFile.getName());
        ((ZipExporter)this.archive.as(ZipExporter.class)).exportTo(tempDestFile, true);
        FileUtils.deleteQuietly((File)new File(pomFile.getFinalName()));
        if ("hook".equals(liferayPluginConfiguration.getPluginType())) {
            HookDeployerTask.INSTANCE.execute(this.session);
        } else {
            PortletDeployerTask.INSTANCE.execute(this.session);
        }
        LiferayPluginConfiguration configuration = new LiferayPluginConfiguration(pomFile);
        File ddPluginArchiveFile = new File(configuration.getDestDir(), pomFile.getArtifactId() + ".war");
        this.archive = (WebArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)pomFile.getFinalName())).importFrom(ddPluginArchiveFile)).as(WebArchive.class);
        try {
            FileUtils.forceDelete((File)ddPluginArchiveFile);
            FileUtils.forceDelete((File)new File(configuration.getBaseDir(), pomFile.getFinalName()));
        }
        catch (IOException e) {
            // empty catch block
        }
        return this;
    }

    private Filter<ArchivePath> applyFilter(WarPluginConfiguration warPluginConfiguration) {
        final List<String> filesToIncludes = Arrays.asList(this.includesFiles(warPluginConfiguration.getWarSourceDirectory(), warPluginConfiguration.getExcludes()));
        return new Filter<ArchivePath>(){

            public boolean include(ArchivePath archivePath) {
                String strFilePath = archivePath.get();
                if (filesToIncludes.contains(strFilePath)) {
                    return true;
                }
                for (String fileToInclude : filesToIncludes) {
                    if (!fileToInclude.startsWith(strFilePath)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private String[] includesFiles(File baseDir, String[] excludes) {
        DirectoryScanner dirScanner = new DirectoryScanner();
        dirScanner.setBasedir(baseDir);
        if (excludes != null) {
            dirScanner.setExcludes(excludes);
        }
        dirScanner.addDefaultExcludes();
        dirScanner.scan();
        String[] includedFiles = dirScanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            includedFiles[i] = "/" + includedFiles[i].replace(File.separator, "/");
        }
        return includedFiles;
    }
}

