/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.liferay.maven.internal.tasks;

import java.io.File;
import java.util.HashMap;
import org.arquillian.liferay.maven.internal.LiferayPluginConfiguration;
import org.arquillian.liferay.maven.internal.tasks.ExecuteDeployerTask;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.task.MavenWorkingSessionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HookDeployerTask implements MavenWorkingSessionTask<MavenWorkingSession>
{
    INSTANCE;

    private static final Logger _log;

    public MavenWorkingSession execute(MavenWorkingSession session) {
        if (_log.isDebugEnabled()) {
            _log.debug("Building Hook Archive");
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("deployerClassName", "com.liferay.portal.tools.deploy.HookDeployer");
        ParsedPomFile pomFile = session.getParsedPomFile();
        LiferayPluginConfiguration configuration = new LiferayPluginConfiguration(pomFile);
        File appServerLibPortalDir = new File(configuration.getAppServerLibPortalDir());
        String libPath = appServerLibPortalDir.getAbsolutePath();
        String[] jars = new String[]{libPath + "/util-java.jar"};
        args.put("jars", jars);
        ExecuteDeployerTask.INSTANCE.execute(session, configuration, args);
        return session;
    }

    static {
        _log = LoggerFactory.getLogger(HookDeployerTask.class);
    }
}

