/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.liferay.maven.internal.tasks;

import java.io.File;
import java.util.HashMap;
import org.arquillian.liferay.maven.internal.LiferayPluginConfiguration;
import org.arquillian.liferay.maven.internal.tasks.ExecuteDeployerTask;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.task.MavenWorkingSessionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PortletDeployerTask implements MavenWorkingSessionTask<MavenWorkingSession>
{
    INSTANCE;

    private static final Logger _log;

    public MavenWorkingSession execute(MavenWorkingSession session) {
        if (_log.isDebugEnabled()) {
            _log.debug("Building Portlet Archive");
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("deployerClassName", "com.liferay.portal.tools.deploy.PortletDeployer");
        ParsedPomFile pomFile = session.getParsedPomFile();
        LiferayPluginConfiguration configuration = new LiferayPluginConfiguration(pomFile);
        String customPortletXml = String.valueOf(configuration.isCustomPortletXml());
        String tldPath = configuration.getAppServerTldPortalDir();
        System.setProperty("deployer.aui.taglib.dtd", tldPath + "/aui.tld");
        System.setProperty("deployer.custom.portlet.xml", String.valueOf(customPortletXml));
        System.setProperty("deployer.portlet.taglib.dtd", tldPath + "/liferay-portlet.tld");
        System.setProperty("deployer.portlet-ext.taglib.dtd", tldPath + "/liferay-portlet-ext.tld");
        System.setProperty("deployer.security.taglib.dtd", tldPath + "/liferay-security.tld");
        System.setProperty("deployer.theme.taglib.dtd", tldPath + "/liferay-theme.tld");
        System.setProperty("deployer.ui.taglib.dtd", tldPath + "/liferay-ui.tld");
        System.setProperty("deployer.util.taglib.dtd", tldPath + "/liferay-util.tld");
        File appServerLibPortalDir = new File(configuration.getAppServerLibPortalDir());
        String libPath = appServerLibPortalDir.getAbsolutePath();
        String[] jars = new String[]{libPath + "/util-bridges.jar", libPath + "/util-java.jar", libPath + "/util-taglib.jar"};
        args.put("jars", jars);
        ExecuteDeployerTask.INSTANCE.execute(session, configuration, args);
        return session;
    }

    static {
        _log = LoggerFactory.getLogger(PortletDeployerTask.class);
    }
}

