/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.pact.provider.loader.maven;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.arquillian.pact.configuration.PactRunnerExpressionParser;
import org.arquillian.pact.provider.loader.maven.PactMavenDependency;
import org.arquillian.pact.provider.spi.loader.PactLoader;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenVersionRangeResult;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;

public class PactMavenDependencyLoader
implements PactLoader {
    private static final int NAME = 0;
    private static final int URL = 1;
    private static final int LAYOUT = 2;
    private PactMavenDependency pactMavenDependency;

    public PactMavenDependencyLoader(PactMavenDependency pactMavenDependency) {
        this.pactMavenDependency = pactMavenDependency;
    }

    public List<Pact> load(String providerName) throws IOException {
        File pactFolder = this.createTemporaryFolder(providerName);
        this.extractContracts(pactFolder);
        return this.loadPacts(providerName, pactFolder);
    }

    protected List<Pact> loadPacts(String providerName, File pactFolder) {
        File[] files = pactFolder.listFiles((dir, name) -> name.endsWith(".json"));
        if (files != null) {
            return Arrays.stream(files).map(PactReader::loadPact).filter(pact -> pact.getProvider().getName().equals(providerName)).collect(Collectors.toList());
        }
        return new ArrayList<Pact>();
    }

    private void extractContracts(File temporaryDirectory) throws IOException {
        List<JavaArchive> resolvedPacts = this.resolvePacts();
        this.unpack(temporaryDirectory, resolvedPacts);
    }

    protected void unpack(File destination, List<JavaArchive> pacts) throws IOException {
        for (JavaArchive pact : pacts) {
            this.unpack(destination, pact);
        }
    }

    private void unpack(File destination, JavaArchive file) throws IOException {
        Node rootDir = file.get("/");
        Set pactFiles = rootDir.getChildren();
        for (Node pactFile : pactFiles) {
            String filename = pactFile.getPath().get().substring(1);
            Asset asset = pactFile.getAsset();
            InputStream in = asset.openStream();
            Throwable throwable = null;
            try {
                Files.copy(in, new File(destination, filename).toPath(), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    protected List<JavaArchive> resolvePacts() {
        String[] coordinates;
        ArrayList<JavaArchive> pacts = new ArrayList<JavaArchive>();
        ConfigurableMavenResolverSystem configurableMavenResolverSystem = Maven.configureResolver();
        if (!"".equals(this.pactMavenDependency.customSettings())) {
            configurableMavenResolverSystem.fromClassloaderResource(PactRunnerExpressionParser.parseExpressions((String)this.pactMavenDependency.customSettings()));
        }
        if (this.pactMavenDependency.offline()) {
            configurableMavenResolverSystem.workOffline();
        }
        if (!"".equals(this.pactMavenDependency.remoteRepository())) {
            String[] remoteRepository = this.getRemoteRepository(PactRunnerExpressionParser.parseExpressions((String)this.pactMavenDependency.remoteRepository()));
            configurableMavenResolverSystem.withRemoteRepo(remoteRepository[0], remoteRepository[1], remoteRepository[2]);
        }
        for (String coordinate : coordinates = this.pactMavenDependency.value()) {
            pacts.add(this.resolve(PactRunnerExpressionParser.parseExpressions((String)coordinate), configurableMavenResolverSystem));
        }
        return pacts;
    }

    private JavaArchive resolve(String coordinate, ConfigurableMavenResolverSystem maven) {
        MavenCoordinate highestVersion = (MavenCoordinate)((MavenVersionRangeResult)maven.resolveVersionRange(coordinate)).getHighestVersion();
        return (JavaArchive)((MavenFormatStage)((MavenStrategyStage)maven.resolve(highestVersion.toCanonicalForm())).withoutTransitivity()).asSingle(JavaArchive.class);
    }

    private String[] getRemoteRepository(String remoteRepoDefinition) {
        String[] elements = remoteRepoDefinition.split(":");
        if (elements.length != 3) {
            throw new IllegalArgumentException(String.format("Remote Repository must follow the syntax name:url:layout instead of %s", remoteRepoDefinition));
        }
        return elements;
    }

    private File createTemporaryFolder(String provider) throws IOException {
        File createdFolder = File.createTempFile("contracts", provider);
        createdFolder.delete();
        createdFolder.mkdir();
        return createdFolder;
    }
}

