/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.pact.provider.core.loader.pactbroker;

import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactReader;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.arquillian.pact.configuration.PactRunnerExpressionParser;
import org.arquillian.pact.provider.core.loader.pactbroker.PactBroker;
import org.arquillian.pact.provider.spi.loader.PactLoader;

public class PactBrokerLoader
implements PactLoader {
    private static final Logger LOGGER = Logger.getLogger(PactBrokerLoader.class.getName());
    private static final String PACT_URL_PATTERN = "/pacts/provider/{0}/latest";
    private static final String PACT_URL_PATTERN_WITH_TAG = "/pacts/provider/{0}/latest/{1}";
    private final String pactBrokerHost;
    private final String pactBrokerPort;
    private final String pactBrokerProtocol;
    private final List<String> pactBrokerTags;
    private final Retryer<HttpResponse> retryer = RetryerBuilder.newBuilder().retryIfResult(response -> response.getStatusLine().getStatusCode() >= 500).withWaitStrategy(WaitStrategies.exponentialWait((long)100L, (long)1L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)5000L)).build();
    private Callable<HttpResponse> httpResponseCallable;

    public PactBrokerLoader(String pactBrokerHost, String pactBrokerPort, String pactBrokerProtocol) {
        this(pactBrokerHost, pactBrokerPort, pactBrokerProtocol, Collections.singletonList("latest"));
    }

    public PactBrokerLoader(String pactBrokerHost, String pactBrokerPort, String pactBrokerProtocol, List<String> tags) {
        this.pactBrokerHost = pactBrokerHost;
        this.pactBrokerPort = pactBrokerPort;
        this.pactBrokerProtocol = pactBrokerProtocol;
        this.pactBrokerTags = tags;
    }

    public PactBrokerLoader(PactBroker pactBroker) {
        this(PactBrokerLoader.getResolvedValue(pactBroker.host()), PactBrokerLoader.getResolvedValue(pactBroker.port()), PactBrokerLoader.getResolvedValue(pactBroker.protocol()), Arrays.stream(pactBroker.tags()).map(tag -> PactBrokerLoader.getResolvedValue(tag)).collect(Collectors.toList()));
    }

    public List<Pact> load(String providerName) throws IOException {
        ArrayList<Pact> pacts = new ArrayList<Pact>();
        for (String tag : this.pactBrokerTags) {
            pacts.addAll(this.loadPactsForProvider(providerName, tag));
        }
        return pacts;
    }

    private List<Pact> loadPactsForProvider(String providerName, String tag) throws IOException {
        JsonArray pacts;
        HttpResponse httpResponse;
        LOGGER.log(Level.FINER, String.format("Loading pacts from pact broker for provider %s and tag %s ", providerName, tag));
        try {
            URIBuilder uriBuilder = new URIBuilder().setScheme(PactRunnerExpressionParser.parseExpressions((String)this.pactBrokerProtocol)).setHost(PactRunnerExpressionParser.parseExpressions((String)this.pactBrokerHost)).setPort(Integer.parseInt(PactRunnerExpressionParser.parseExpressions((String)this.pactBrokerPort)));
            if (tag.equals("latest")) {
                uriBuilder.setPath(MessageFormat.format(PACT_URL_PATTERN, providerName));
            } else {
                uriBuilder.setPath(MessageFormat.format(PACT_URL_PATTERN_WITH_TAG, providerName, tag));
            }
            URI brokerUri = uriBuilder.build();
            httpResponse = this.httpResponseCallable == null ? (HttpResponse)this.retryer.call(() -> Request.Get((URI)brokerUri).setHeader("Accept", "application/hal+json").execute().returnResponse()) : (HttpResponse)this.retryer.call(this.httpResponseCallable);
        }
        catch (RetryException | URISyntaxException | ExecutionException e) {
            throw new IOException("Was not able load pacts from broker", e);
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode == 404) {
            LOGGER.log(Level.WARNING, String.format("There are no pacts found for the service %s and tag %s", providerName, tag));
            return Collections.emptyList();
        }
        InputStream content = httpResponse.getEntity().getContent();
        if (statusCode / 100 != 2) {
            throw new RuntimeException("Pact broker responded with status: " + statusCode + "\n payload: '" + PactBrokerLoader.asStringPreservingNewLines(content) + "'");
        }
        JsonValue parse = Json.parse((Reader)new InputStreamReader(content));
        JsonObject fullList = parse.asObject();
        JsonObject links = fullList.get("_links").asObject();
        if (links != null && (pacts = links.get("pacts").asArray()) != null) {
            return StreamSupport.stream(pacts.spliterator(), false).map(jsonNode -> jsonNode.asObject().getString("href", "")).map(PactReader::loadPact).collect(Collectors.toList());
        }
        return new ArrayList<Pact>();
    }

    public Callable<HttpResponse> getHttpResponseCallable() {
        return this.httpResponseCallable;
    }

    public void setHttpResponseCallable(Callable<HttpResponse> httpResponseCallable) {
        this.httpResponseCallable = httpResponseCallable;
    }

    private static String asStringPreservingNewLines(InputStream response) {
        StringWriter logwriter = new StringWriter();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                logwriter.write(line);
                logwriter.write(System.lineSeparator());
            }
            return logwriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getResolvedValue(String field) {
        return PactRunnerExpressionParser.parseExpressions((String)field);
    }
}

