/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.server.atom.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.artificer.atom.err.ArtificerAtomException;
import org.artificer.common.ArtificerConstants;
import org.artificer.repository.query.PagedResult;
import org.artificer.server.AuditServiceImpl;
import org.artificer.server.atom.services.AbstractResource;
import org.artificer.server.i18n.Messages;
import org.jboss.downloads.artificer._2013.auditing.AuditEntry;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/s-ramp")
public class AuditResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(AuditResource.class);
    private final AuditServiceImpl auditService = new AuditServiceImpl();

    @POST
    @Path(value="audit/artifact/{artifactUuid}")
    @Consumes(value={"application/auditEntry+xml"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@PathParam(value="artifactUuid") String artifactUuid, AuditEntry auditEntry) throws ArtificerAtomException {
        try {
            AuditEntry rval = this.auditService.create(artifactUuid, auditEntry);
            return this.auditEntryToAtomEntry(rval);
        }
        catch (Throwable e) {
            AuditResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_AUDIT_ENTRY", new Object[]{artifactUuid}), (Throwable)e);
            throw new ArtificerAtomException(e);
        }
    }

    @GET
    @Path(value="audit/artifact/{artifactUuid}/{auditEntryUuid}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry get(@PathParam(value="artifactUuid") String artifactUuid, @PathParam(value="auditEntryUuid") String auditEntryUuid) throws ArtificerAtomException {
        try {
            AuditEntry auditEntry = this.auditService.get(artifactUuid, auditEntryUuid);
            return this.auditEntryToAtomEntry(auditEntry);
        }
        catch (Throwable e) {
            AuditResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_GETTING_AUDIT_ENTRY", new Object[]{artifactUuid, auditEntryUuid}), (Throwable)e);
            throw new ArtificerAtomException(e);
        }
    }

    @GET
    @Path(value="audit/artifact/{artifactUuid}")
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed listForArtifact(@PathParam(value="artifactUuid") String artifactUuid, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="startIndex") Integer startIndex, @QueryParam(value="count") Integer count) throws ArtificerAtomException {
        try {
            PagedResult entries = this.auditService.queryByArtifact(artifactUuid, startPage, startIndex, count);
            return this.createAuditFeed(entries);
        }
        catch (Throwable e) {
            AuditResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_GETTING_AUDIT_ENTRIES", new Object[]{artifactUuid}), (Throwable)e);
            throw new ArtificerAtomException(e);
        }
    }

    @GET
    @Path(value="audit/user/{username}")
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed listForUser(@PathParam(value="username") String username, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="startIndex") Integer startIndex, @QueryParam(value="count") Integer count) throws ArtificerAtomException {
        try {
            PagedResult entries = this.auditService.queryByUser(username, startPage, startIndex, count);
            return this.createAuditFeed(entries);
        }
        catch (Throwable e) {
            AuditResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_GETTING_AUDIT_ENTRIES_2", new Object[]{username}), (Throwable)e);
            throw new ArtificerAtomException(e);
        }
    }

    private Feed createAuditFeed(PagedResult<AuditEntry> auditEntries) throws Exception {
        Feed feed = new Feed();
        feed.getExtensionAttributes().put(ArtificerConstants.SRAMP_PROVIDER_QNAME, "JBoss Overlord");
        feed.getExtensionAttributes().put(ArtificerConstants.SRAMP_ITEMS_PER_PAGE_QNAME, String.valueOf(auditEntries.getPageSize()));
        feed.getExtensionAttributes().put(ArtificerConstants.SRAMP_START_INDEX_QNAME, String.valueOf(auditEntries.getStartIndex()));
        feed.getExtensionAttributes().put(ArtificerConstants.SRAMP_TOTAL_RESULTS_QNAME, String.valueOf(auditEntries.getTotalSize()));
        feed.setId(new URI("urn:uuid:" + UUID.randomUUID().toString()));
        feed.setTitle("S-RAMP Audit Feed");
        feed.setSubtitle("All Audit Entries for Artifact");
        feed.setUpdated(new Date());
        for (AuditEntry auditEntry : auditEntries.getResults()) {
            Entry entry = new Entry();
            entry.setId(new URI(auditEntry.getUuid()));
            entry.setPublished(auditEntry.getWhen().toGregorianCalendar().getTime());
            entry.setUpdated(auditEntry.getWhen().toGregorianCalendar().getTime());
            entry.getAuthors().add(new Person(auditEntry.getWho()));
            entry.setTitle(auditEntry.getType());
            entry.setSummary("");
            feed.getEntries().add(entry);
        }
        return feed;
    }

    private Entry auditEntryToAtomEntry(AuditEntry auditEntry) throws URISyntaxException {
        Entry entry = new Entry();
        entry.setId(new URI("urn:uuid:" + auditEntry.getUuid()));
        entry.setPublished(auditEntry.getWhen().toGregorianCalendar().getTime());
        entry.setUpdated(auditEntry.getWhen().toGregorianCalendar().getTime());
        entry.getAuthors().add(new Person(auditEntry.getWho()));
        entry.setTitle(auditEntry.getType());
        entry.setSummary("");
        entry.setAnyOtherJAXBObject((Object)auditEntry);
        return entry;
    }
}

