/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.GlobalStructureView;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.swing.AJButtonMenuCombo;
import org.aspectj.ajde.ui.swing.AjdeWidgetStyles;
import org.aspectj.ajde.ui.swing.StructureViewPanel;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;

public class BrowserStructureViewToolPanel
extends JPanel {
    private static final long serialVersionUID = 7960528108612681776L;
    private StructureView currentView;
    private StructureViewPanel viewPanel;
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected Border border1;
    protected Border border2;
    AJButtonMenuCombo granularityCombo;
    AJButtonMenuCombo filterCombo;
    AJButtonMenuCombo relationsCombo;
    JPanel buttons_panel = new JPanel();
    JPanel spacer_panel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel view_panel = new JPanel();
    JComboBox view_comboBox = null;
    JLabel view_label = new JLabel();
    BorderLayout borderLayout4 = new BorderLayout();

    public BrowserStructureViewToolPanel(List structureViews, StructureView currentView, StructureViewPanel viewPanel) {
        this.currentView = currentView;
        this.viewPanel = viewPanel;
        this.view_comboBox = new JComboBox();
        this.view_comboBox.setFont(AjdeWidgetStyles.DEFAULT_LABEL_FONT);
        for (Object structureView : structureViews) {
            this.view_comboBox.addItem(structureView);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Message msg = new Message("Could not initialize GUI.", IMessage.ERROR, e, null);
            Ajde.getDefault().getMessageHandler().handleMessage(msg);
        }
        this.initToolBar();
    }

    private void initToolBar() {
        try {
            this.granularityCombo = new AJButtonMenuCombo("Visible granularity", "Visible granularity", Ajde.getDefault().getIconRegistry().getGranularityIcon(), this.createGranularityMenu(), false);
            this.filterCombo = new AJButtonMenuCombo("Filter members", "Filter members", Ajde.getDefault().getIconRegistry().getFilterIcon(), this.createFilterMenu(), false);
            this.relationsCombo = new AJButtonMenuCombo("Filter associations", "Filter associations", Ajde.getDefault().getIconRegistry().getRelationsIcon(), this.createRelationsMenu(), false);
            this.buttons_panel.add((Component)this.granularityCombo, "West");
            this.buttons_panel.add((Component)this.filterCombo, "Center");
            this.buttons_panel.add((Component)this.relationsCombo, "East");
        }
        catch (Exception e) {
            Message msg = new Message("Could not initialize GUI.", IMessage.ERROR, e, null);
            Ajde.getDefault().getMessageHandler().handleMessage(msg);
        }
    }

    private JPopupMenu createFilterMenu() {
        IProgramElement.Modifiers[] modifiers;
        IProgramElement.Kind[] kinds;
        IProgramElement.Accessibility[] accessibility;
        JPopupMenu filterMenu = new JPopupMenu();
        for (IProgramElement.Accessibility value : accessibility = IProgramElement.Accessibility.ALL) {
            CheckBoxSelectionMenuButton menuItem = new CheckBoxSelectionMenuButton(value);
            menuItem.setIcon(Ajde.getDefault().getIconRegistry().getAccessibilitySwingIcon(value));
            filterMenu.add(menuItem);
        }
        filterMenu.add(new JSeparator());
        for (IProgramElement.Kind kind : kinds = IProgramElement.Kind.ALL) {
            if (!kind.isMember()) continue;
            CheckBoxSelectionMenuButton menuItem = new CheckBoxSelectionMenuButton(kind);
            menuItem.setIcon((Icon)Ajde.getDefault().getIconRegistry().getIcon(kind).getIconResource());
            filterMenu.add(menuItem);
        }
        filterMenu.add(new JSeparator());
        for (IProgramElement.Modifiers modifier : modifiers = IProgramElement.Modifiers.ALL) {
            CheckBoxSelectionMenuButton menuItem = new CheckBoxSelectionMenuButton(modifier);
            filterMenu.add(menuItem);
        }
        return filterMenu;
    }

    private JPopupMenu createRelationsMenu() {
        JPopupMenu relationsMenu = new JPopupMenu();
        List relations = Ajde.getDefault().getStructureViewManager().getAvailableRelations();
        for (Object o : relations) {
            IRelationship.Kind relation = (IRelationship.Kind)o;
            CheckBoxSelectionMenuButton menuItem = new CheckBoxSelectionMenuButton(relation);
            menuItem.setIcon((Icon)Ajde.getDefault().getIconRegistry().getIcon(relation).getIconResource());
            relationsMenu.add(menuItem);
        }
        return relationsMenu;
    }

    private JPopupMenu createGranularityMenu() {
        JPopupMenu orderMenu = new JPopupMenu();
        StructureViewProperties.Granularity[] granularity = StructureViewProperties.Granularity.ALL;
        ButtonGroup group = new ButtonGroup();
        for (StructureViewProperties.Granularity value : granularity) {
            RadioSelectionMenuButton menuItem = new RadioSelectionMenuButton(value, group);
            orderMenu.add(menuItem);
            if (!value.equals(StructureViewProperties.Granularity.MEMBER)) continue;
            menuItem.setSelected(true);
        }
        return orderMenu;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout2);
        this.buttons_panel.setLayout(this.borderLayout3);
        this.buttons_panel.setMinimumSize(new Dimension(105, 10));
        this.buttons_panel.setPreferredSize(new Dimension(105, 10));
        this.view_comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserStructureViewToolPanel.this.view_comboBox_actionPerformed(e);
            }
        });
        this.view_label.setFont(new Font("Dialog", 0, 11));
        this.view_label.setText("  Global View   ");
        this.view_comboBox.setFont(new Font("SansSerif", 0, 11));
        this.view_comboBox.setPreferredSize(new Dimension(125, 22));
        this.view_panel.setLayout(this.borderLayout4);
        this.view_panel.add((Component)this.view_label, "West");
        this.add((Component)this.buttons_panel, "East");
        this.add((Component)this.spacer_panel, "Center");
        this.add((Component)this.view_panel, "West");
        this.view_panel.add((Component)this.view_comboBox, "Center");
    }

    void separator_button_actionPerformed(ActionEvent e) {
    }

    void view_comboBox_actionPerformed(ActionEvent e) {
        StructureView view = (StructureView)this.view_comboBox.getSelectedItem();
        this.viewPanel.setCurrentView(view);
        if (((GlobalStructureView)view).getGlobalViewProperties().getHierarchy() == StructureViewProperties.Hierarchy.DECLARATION) {
            this.granularityCombo.setEnabled(true);
            this.relationsCombo.setEnabled(true);
            this.filterCombo.setEnabled(true);
        } else {
            this.granularityCombo.setEnabled(false);
            this.relationsCombo.setEnabled(false);
            this.filterCombo.setEnabled(false);
        }
    }

    private class CheckBoxSelectionMenuButton
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = -4555502313984854787L;

        public CheckBoxSelectionMenuButton(String name) {
            super(name);
            this.setFont(AjdeWidgetStyles.DEFAULT_LABEL_FONT);
            this.setBackground(AjdeWidgetStyles.DEFAULT_BACKGROUND_COLOR);
        }

        public CheckBoxSelectionMenuButton(IProgramElement.Accessibility accessibility) {
            this(accessibility.toString());
            this.addActionListener(browserStructureViewToolPanel.new CheckBoxSelectionMenuActionListener(accessibility));
        }

        public CheckBoxSelectionMenuButton(IProgramElement.Kind kind) {
            this(kind.toString());
            this.addActionListener(browserStructureViewToolPanel.new CheckBoxSelectionMenuActionListener(kind));
        }

        public CheckBoxSelectionMenuButton(IProgramElement.Modifiers modifiers) {
            this(modifiers.toString());
            this.addActionListener(browserStructureViewToolPanel.new CheckBoxSelectionMenuActionListener(modifiers));
        }

        public CheckBoxSelectionMenuButton(StructureViewProperties.Sorting sorting) {
            this(sorting.toString());
            this.addActionListener(browserStructureViewToolPanel.new CheckBoxSelectionMenuActionListener(sorting));
        }

        public CheckBoxSelectionMenuButton(IRelationship.Kind relation) {
            this(relation.toString());
            this.addActionListener(browserStructureViewToolPanel.new CheckBoxSelectionMenuActionListener(relation));
        }
    }

    private class RadioSelectionMenuButton
    extends JRadioButtonMenuItem {
        private static final long serialVersionUID = -879644981405801807L;

        public RadioSelectionMenuButton(StructureViewProperties.Granularity granularity, ButtonGroup group) {
            super(granularity.toString());
            super.setFont(AjdeWidgetStyles.DEFAULT_LABEL_FONT);
            group.add(this);
            this.addActionListener(new RadioSelectionMenuActionListener(granularity));
        }
    }

    private class CheckBoxSelectionMenuActionListener
    implements ActionListener {
        private IProgramElement.Accessibility accessibility = null;
        private IProgramElement.Kind kind = null;
        private IProgramElement.Modifiers modifiers = null;
        private StructureViewProperties.Sorting sorting = null;
        private IRelationship.Kind relation = null;

        public CheckBoxSelectionMenuActionListener(IProgramElement.Accessibility accessibility) {
            this.accessibility = accessibility;
        }

        public CheckBoxSelectionMenuActionListener(IProgramElement.Kind kind) {
            this.kind = kind;
        }

        public CheckBoxSelectionMenuActionListener(IProgramElement.Modifiers modifiers) {
            this.modifiers = modifiers;
        }

        public CheckBoxSelectionMenuActionListener(StructureViewProperties.Sorting sorting) {
            this.sorting = sorting;
        }

        public CheckBoxSelectionMenuActionListener(IRelationship.Kind relationKind) {
            this.relation = relationKind;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof CheckBoxSelectionMenuButton)) {
                return;
            }
            CheckBoxSelectionMenuButton checkMenu = (CheckBoxSelectionMenuButton)e.getSource();
            if (this.accessibility != null) {
                if (checkMenu.isSelected()) {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().addFilteredMemberAccessibility(this.accessibility);
                } else {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().removeFilteredMemberAccessibility(this.accessibility);
                }
            } else if (this.kind != null) {
                if (checkMenu.isSelected()) {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().addFilteredMemberKind(this.kind);
                } else {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().removeFilteredMemberKind(this.kind);
                }
            } else if (this.modifiers != null) {
                if (checkMenu.isSelected()) {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().addFilteredMemberModifiers(this.modifiers);
                } else {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().removeFilteredMemberModifiers(this.modifiers);
                }
            } else if (this.sorting != null) {
                if (checkMenu.isSelected()) {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().setSorting(this.sorting);
                } else {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().setSorting(StructureViewProperties.Sorting.DECLARATIONAL);
                }
            } else if (this.relation != null) {
                if (checkMenu.isSelected()) {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().removeRelation(this.relation);
                } else {
                    BrowserStructureViewToolPanel.this.currentView.getViewProperties().addRelation(this.relation);
                }
            }
            Ajde.getDefault().getStructureViewManager().refreshView(BrowserStructureViewToolPanel.this.currentView);
        }
    }

    private class RadioSelectionMenuActionListener
    implements ActionListener {
        private StructureViewProperties.Granularity granularity;

        public RadioSelectionMenuActionListener(StructureViewProperties.Granularity granularity) {
            this.granularity = granularity;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowserStructureViewToolPanel.this.currentView.getViewProperties().setGranularity(this.granularity);
            Ajde.getDefault().getStructureViewManager().refreshView(BrowserStructureViewToolPanel.this.currentView);
        }
    }
}

