/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;

public class EmacsStructureModelManager {
    private static final String EXTERN_FILE_SUFFIX = ".ajesym";

    public void externalizeModel(AsmManager model) {
        if (!model.getHierarchy().isValid()) {
            return;
        }
        try {
            Set<Map.Entry<String, IProgramElement>> fileSet = model.getHierarchy().getFileMapEntrySet();
            for (Map.Entry<String, IProgramElement> o : fileSet) {
                IProgramElement peNode = o.getValue();
                this.dumpStructureToFile(peNode);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpStructureToFile(IProgramElement node) throws IOException {
        String s = node.getKind().toString();
        if (!s.equals(IProgramElement.Kind.FILE_ASPECTJ.toString()) && !s.equals(IProgramElement.Kind.FILE_JAVA.toString())) {
            throw new IllegalArgumentException("externalize file, not " + node);
        }
        String sourceName = node.getSourceLocation().getSourceFile().getAbsolutePath();
        String fileName = sourceName.substring(0, sourceName.lastIndexOf(".")) + EXTERN_FILE_SUFFIX;
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(new File(fileName)));
            new SExpressionPrinter(writer).printDecls(node);
            writer.flush();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class SExpressionPrinter {
        private BufferedWriter writer = null;

        public SExpressionPrinter(BufferedWriter writer) {
            this.writer = writer;
        }

        private void printDecls(IProgramElement node) {
            this.print("(");
            for (IProgramElement child : node.getChildren()) {
                this.printDecl(child, true);
            }
            this.print(") ");
        }

        private void printDecl(IProgramElement node, boolean recurse) {
            if (node == null || node.getSourceLocation() == null) {
                return;
            }
            String kind = node.getKind().toString().toLowerCase();
            this.print("(");
            this.print("(" + node.getSourceLocation().getLine() + " . " + node.getSourceLocation().getColumn() + ") ");
            this.print("(" + node.getSourceLocation().getLine() + " . " + node.getSourceLocation().getColumn() + ") ");
            this.print(kind + " ");
            String displayName = node.toString().replace('\"', ' ');
            this.print("\"" + displayName + "\" ");
            if (node.getSourceLocation().getSourceFile().getAbsolutePath() != null) {
                this.print("\"" + this.fixFilename(node.getSourceLocation().getSourceFile().getAbsolutePath()) + "\"");
            } else {
                this.print("nil");
            }
            if (node.getName() != null) {
                this.print("\"" + node.getDeclaringType() + "\" ");
            } else {
                this.print("nil");
            }
            if (!recurse) {
                this.print("nil");
                this.print("nil");
                this.print("nil");
            } else {
                this.print("(");
                this.print(") ");
                this.print("(");
                this.print(") ");
                this.print("(");
                Iterator<IProgramElement> it3 = node.getChildren().iterator();
                if (it3.hasNext()) {
                    while (it3.hasNext()) {
                        IProgramElement currNode = it3.next();
                        if (currNode.getKind().equals("<undefined>")) continue;
                        this.printDecl(currNode, true);
                    }
                }
                this.print(") ");
            }
            this.print(node.getKind().equals("class") ? "t " : "nil ");
            this.print(node.getKind().equals("introduction") ? "nil " : "nil ");
            this.print("nil ");
            this.print("nil ");
            this.print(")");
        }

        String fixFilename(String filename) {
            return this.subst("\\\\", "\\", filename);
        }

        private void print(String string) {
            try {
                this.writer.write(string + "\n");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private String subst(String n, String o, String in) {
            int pos = in.indexOf(o);
            if (pos == -1) {
                return in;
            }
            return in.substring(0, pos) + n + this.subst(n, o, in.substring(pos + o.length()));
        }
    }
}

