/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom.rewrite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.org.eclipse.jdt.core.Flags;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IImportDeclaration;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.ITypeRoot;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTParser;
import org.aspectj.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.AnnotatableType;
import org.aspectj.org.eclipse.jdt.core.dom.Annotation;
import org.aspectj.org.eclipse.jdt.core.dom.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.core.dom.ArrayType;
import org.aspectj.org.eclipse.jdt.core.dom.CharacterLiteral;
import org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit;
import org.aspectj.org.eclipse.jdt.core.dom.Dimension;
import org.aspectj.org.eclipse.jdt.core.dom.Expression;
import org.aspectj.org.eclipse.jdt.core.dom.FieldAccess;
import org.aspectj.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IMethodBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IPackageBinding;
import org.aspectj.org.eclipse.jdt.core.dom.ITypeBinding;
import org.aspectj.org.eclipse.jdt.core.dom.IVariableBinding;
import org.aspectj.org.eclipse.jdt.core.dom.ImportDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.aspectj.org.eclipse.jdt.core.dom.MemberValuePair;
import org.aspectj.org.eclipse.jdt.core.dom.Modifier;
import org.aspectj.org.eclipse.jdt.core.dom.Name;
import org.aspectj.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.aspectj.org.eclipse.jdt.core.dom.ParameterizedType;
import org.aspectj.org.eclipse.jdt.core.dom.PrimitiveType;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleType;
import org.aspectj.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.core.dom.StringLiteral;
import org.aspectj.org.eclipse.jdt.core.dom.Type;
import org.aspectj.org.eclipse.jdt.core.dom.TypeLiteral;
import org.aspectj.org.eclipse.jdt.core.dom.WildcardType;
import org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportRewriteAnalyzer;
import org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite.imports.ImportRewriteConfiguration;
import org.aspectj.org.eclipse.jdt.internal.core.util.Messages;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public final class ImportRewrite {
    private static final char STATIC_PREFIX = 's';
    private static final char NORMAL_PREFIX = 'n';
    private static final int JLS8_INTERNAL = 8;
    private final ImportRewriteContext defaultContext;
    private final ICompilationUnit compilationUnit;
    private final CompilationUnit astRoot;
    private final boolean restoreExistingImports;
    private final List existingImports;
    private final Map importsKindMap;
    private String[] importOrder;
    private int importOnDemandThreshold;
    private int staticImportOnDemandThreshold;
    private List<String> addedImports;
    private List<String> removedImports;
    private Set<String> typeExplicitSimpleNames;
    private Set<String> staticExplicitSimpleNames;
    private String[] createdImports;
    private String[] createdStaticImports;
    private boolean filterImplicitImports;
    private boolean useContextToFilterImplicitImports;

    public static ImportRewrite create(ICompilationUnit cu, boolean restoreExistingImports) throws JavaModelException {
        if (cu == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        ArrayList<String> existingImport = null;
        if (restoreExistingImports) {
            existingImport = new ArrayList<String>();
            IImportDeclaration[] imports = cu.getImports();
            int i = 0;
            while (i < imports.length) {
                IImportDeclaration curr = imports[i];
                char prefix = Flags.isStatic(curr.getFlags()) ? (char)'s' : 'n';
                existingImport.add(String.valueOf(prefix) + curr.getElementName());
                ++i;
            }
        }
        return new ImportRewrite(cu, null, existingImport);
    }

    public static ImportRewrite create(CompilationUnit astRoot, boolean restoreExistingImports) {
        if (astRoot == null) {
            throw new IllegalArgumentException("AST must not be null");
        }
        ITypeRoot typeRoot = astRoot.getTypeRoot();
        if (!(typeRoot instanceof ICompilationUnit)) {
            throw new IllegalArgumentException("AST must have been constructed from a Java element");
        }
        ArrayList<String> existingImport = null;
        if (restoreExistingImports) {
            existingImport = new ArrayList<String>();
            List imports = astRoot.imports();
            int i = 0;
            while (i < imports.size()) {
                ImportDeclaration curr = (ImportDeclaration)imports.get(i);
                StringBuilder buf = new StringBuilder();
                buf.append(curr.isStatic() ? (char)'s' : 'n').append(curr.getName().getFullyQualifiedName());
                if (curr.isOnDemand()) {
                    if (buf.length() > 1) {
                        buf.append('.');
                    }
                    buf.append('*');
                }
                existingImport.add(buf.toString());
                ++i;
            }
        }
        return new ImportRewrite((ICompilationUnit)typeRoot, astRoot, existingImport);
    }

    private ImportRewrite(ICompilationUnit cu, CompilationUnit astRoot, List existingImports) {
        this.compilationUnit = cu;
        this.astRoot = astRoot;
        if (existingImports != null) {
            this.existingImports = existingImports;
            this.restoreExistingImports = !existingImports.isEmpty();
        } else {
            this.existingImports = new ArrayList();
            this.restoreExistingImports = false;
        }
        this.filterImplicitImports = true;
        this.useContextToFilterImplicitImports = false;
        this.defaultContext = new ImportRewriteContext(){

            @Override
            public int findInContext(String qualifier, String name, int kind) {
                return ImportRewrite.this.findInImports(qualifier, name, kind);
            }
        };
        this.addedImports = new ArrayList<String>();
        this.removedImports = new ArrayList<String>();
        this.typeExplicitSimpleNames = new HashSet<String>();
        this.staticExplicitSimpleNames = new HashSet<String>();
        this.createdImports = null;
        this.createdStaticImports = null;
        this.importOrder = CharOperation.NO_STRINGS;
        this.importOnDemandThreshold = 99;
        this.staticImportOnDemandThreshold = 99;
        this.importsKindMap = new HashMap();
    }

    public void setImportOrder(String[] order) {
        if (order == null) {
            throw new IllegalArgumentException("Order must not be null");
        }
        this.importOrder = order;
    }

    public void setOnDemandImportThreshold(int threshold) {
        if (threshold <= 0) {
            throw new IllegalArgumentException("Threshold must be positive.");
        }
        this.importOnDemandThreshold = threshold;
    }

    public void setStaticOnDemandImportThreshold(int threshold) {
        if (threshold <= 0) {
            throw new IllegalArgumentException("Threshold must be positive.");
        }
        this.staticImportOnDemandThreshold = threshold;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public ImportRewriteContext getDefaultImportRewriteContext() {
        return this.defaultContext;
    }

    public void setFilterImplicitImports(boolean filterImplicitImports) {
        this.filterImplicitImports = filterImplicitImports;
    }

    public void setUseContextToFilterImplicitImports(boolean useContextToFilterImplicitImports) {
        this.useContextToFilterImplicitImports = useContextToFilterImplicitImports;
    }

    private static int compareImport(char prefix, String qualifier, String name, String curr) {
        if (curr.charAt(0) != prefix || !curr.endsWith(name)) {
            return 2;
        }
        if ((curr = curr.substring(1)).length() == name.length()) {
            if (qualifier.length() == 0) {
                return 1;
            }
            return 3;
        }
        int dotPos = curr.length() - name.length() - 1;
        if (curr.charAt(dotPos) != '.') {
            return 2;
        }
        if (qualifier.length() != dotPos || !curr.startsWith(qualifier)) {
            return 3;
        }
        return 1;
    }

    final int findInImports(String qualifier, String name, int kind) {
        boolean allowAmbiguity = kind == 3 || name.length() == 1 && name.charAt(0) == '*';
        List imports = this.existingImports;
        char prefix = kind == 1 ? (char)'n' : 's';
        int i = imports.size() - 1;
        while (i >= 0) {
            String curr = (String)imports.get(i);
            int res = ImportRewrite.compareImport(prefix, qualifier, name, curr);
            if (!(res == 2 || allowAmbiguity && res != 1)) {
                if (prefix != 's') {
                    return res;
                }
                Object currKind = this.importsKindMap.get(curr.substring(1));
                if (currKind != null && currKind.equals(this.importsKindMap.get(String.valueOf(qualifier) + '.' + name))) {
                    return res;
                }
            }
            --i;
        }
        String packageName = this.compilationUnit.getParent().getElementName();
        if (kind == 1 && this.filterImplicitImports && this.useContextToFilterImplicitImports) {
            IType[] types;
            String mainTypeSimpleName = JavaCore.removeJavaLikeExtension(this.compilationUnit.getElementName());
            String mainTypeName = Util.concatenateName(packageName, mainTypeSimpleName, '.');
            if (qualifier.equals(packageName) || mainTypeName.equals(Util.concatenateName(qualifier, name, '.'))) {
                return 1;
            }
            if (this.astRoot != null) {
                types = this.astRoot.types();
                int nTypes = types.size();
                int i2 = 0;
                while (i2 < nTypes) {
                    AbstractTypeDeclaration type = (AbstractTypeDeclaration)types.get(i2);
                    SimpleName simpleName = type.getName();
                    if (simpleName.getIdentifier().equals(name)) {
                        return qualifier.equals(packageName) ? 1 : 3;
                    }
                    ++i2;
                }
            } else {
                try {
                    types = this.compilationUnit.getTypes();
                    int nTypes = types.length;
                    int i3 = 0;
                    while (i3 < nTypes) {
                        IType type = types[i3];
                        String typeName = type.getElementName();
                        if (typeName.equals(name)) {
                            return qualifier.equals(packageName) ? 1 : 3;
                        }
                        ++i3;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return 2;
    }

    public Annotation addAnnotation(IAnnotationBinding annotation, AST ast, ImportRewriteContext context) {
        Name name;
        Type type = this.addImport(annotation.getAnnotationType(), ast, context, TypeLocation.OTHER);
        if (type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            name = simpleType.getName();
            simpleType.setName(ast.newName("a"));
        } else {
            name = ast.newName("invalid");
        }
        IMemberValuePairBinding[] mvps = annotation.getDeclaredMemberValuePairs();
        if (mvps.length == 0) {
            MarkerAnnotation result = ast.newMarkerAnnotation();
            result.setTypeName(name);
            return result;
        }
        if (mvps.length == 1 && "value".equals(mvps[0].getName())) {
            SingleMemberAnnotation result = ast.newSingleMemberAnnotation();
            result.setTypeName(name);
            Object value = mvps[0].getValue();
            if (value != null) {
                result.setValue(this.addAnnotation(ast, value, context));
            }
            return result;
        }
        NormalAnnotation result = ast.newNormalAnnotation();
        result.setTypeName(name);
        int i = 0;
        while (i < mvps.length) {
            IMemberValuePairBinding mvp = mvps[i];
            MemberValuePair mvpNode = ast.newMemberValuePair();
            mvpNode.setName(ast.newSimpleName(mvp.getName()));
            Object value = mvp.getValue();
            if (value != null) {
                mvpNode.setValue(this.addAnnotation(ast, value, context));
            }
            result.values().add(mvpNode);
            ++i;
        }
        return result;
    }

    public Type addImportFromSignature(String typeSig, AST ast) {
        return this.addImportFromSignature(typeSig, ast, this.defaultContext);
    }

    public Type addImportFromSignature(String typeSig, AST ast, ImportRewriteContext context) {
        if (typeSig == null || typeSig.length() == 0) {
            throw new IllegalArgumentException("Invalid type signature: empty or null");
        }
        int sigKind = Signature.getTypeSignatureKind(typeSig);
        switch (sigKind) {
            case 2: {
                return ast.newPrimitiveType(PrimitiveType.toCode(Signature.toString(typeSig)));
            }
            case 4: {
                Type elementType = this.addImportFromSignature(Signature.getElementType(typeSig), ast, context);
                return ast.newArrayType(elementType, Signature.getArrayCount(typeSig));
            }
            case 1: {
                String erasureSig = Signature.getTypeErasure(typeSig);
                String erasureName = Signature.toString(erasureSig);
                if (erasureSig.charAt(0) == 'L') {
                    erasureName = this.internalAddImport(erasureName, context, false);
                }
                SimpleType baseType = ast.newSimpleType(ast.newName(erasureName));
                String[] typeArguments = Signature.getTypeArguments(typeSig);
                if (typeArguments.length > 0) {
                    ParameterizedType type = ast.newParameterizedType(baseType);
                    List argNodes = type.typeArguments();
                    int i = 0;
                    while (i < typeArguments.length) {
                        String curr = typeArguments[i];
                        if (this.containsNestedCapture(curr)) {
                            argNodes.add(ast.newWildcardType());
                        } else {
                            argNodes.add(this.addImportFromSignature(curr, ast, context));
                        }
                        ++i;
                    }
                    return type;
                }
                return baseType;
            }
            case 3: {
                return ast.newSimpleType(ast.newSimpleName(Signature.toString(typeSig)));
            }
            case 5: {
                WildcardType wildcardType = ast.newWildcardType();
                char ch = typeSig.charAt(0);
                if (ch != '*') {
                    Type bound = this.addImportFromSignature(typeSig.substring(1), ast, context);
                    wildcardType.setBound(bound, ch == '+');
                }
                return wildcardType;
            }
            case 6: {
                return this.addImportFromSignature(typeSig.substring(1), ast, context);
            }
        }
        throw new IllegalArgumentException("Unknown type signature kind: " + typeSig);
    }

    public String addImport(ITypeBinding binding) {
        return this.addImport(binding, this.defaultContext);
    }

    public String addImport(ITypeBinding binding, ImportRewriteContext context) {
        if (binding.isPrimitive() || binding.isTypeVariable() || binding.isRecovered()) {
            return binding.getName();
        }
        ITypeBinding normalizedBinding = ImportRewrite.normalizeTypeBinding(binding);
        if (normalizedBinding == null) {
            return "invalid";
        }
        if (normalizedBinding.isWildcardType()) {
            StringBuilder res = new StringBuilder("?");
            ITypeBinding bound = normalizedBinding.getBound();
            if (bound != null && !bound.isWildcardType() && !bound.isCapture()) {
                if (normalizedBinding.isUpperbound()) {
                    res.append(" extends ");
                } else {
                    res.append(" super ");
                }
                res.append(this.addImport(bound, context));
            }
            return res.toString();
        }
        if (normalizedBinding.isArray()) {
            StringBuilder res = new StringBuilder(this.addImport(normalizedBinding.getElementType(), context));
            int i = normalizedBinding.getDimensions();
            while (i > 0) {
                res.append("[]");
                --i;
            }
            return res.toString();
        }
        String qualifiedName = ImportRewrite.getRawQualifiedName(normalizedBinding);
        if (qualifiedName.length() > 0) {
            String str = this.internalAddImport(qualifiedName, context, ImportRewrite.isTypeInUnnamedPackage(normalizedBinding));
            ITypeBinding[] typeArguments = normalizedBinding.getTypeArguments();
            if (typeArguments.length > 0) {
                StringBuilder res = new StringBuilder(str);
                res.append('<');
                int i = 0;
                while (i < typeArguments.length) {
                    ITypeBinding curr;
                    if (i > 0) {
                        res.append(',');
                    }
                    if (this.containsNestedCapture(curr = typeArguments[i], false)) {
                        res.append('?');
                    } else {
                        res.append(this.addImport(curr, context));
                    }
                    ++i;
                }
                res.append('>');
                return res.toString();
            }
            return str;
        }
        return ImportRewrite.getRawName(normalizedBinding);
    }

    private boolean containsNestedCapture(ITypeBinding binding, boolean isNested) {
        if (binding == null || binding.isPrimitive() || binding.isTypeVariable()) {
            return false;
        }
        if (binding.isCapture()) {
            if (isNested) {
                return true;
            }
            return this.containsNestedCapture(binding.getWildcard(), true);
        }
        if (binding.isWildcardType()) {
            return this.containsNestedCapture(binding.getBound(), true);
        }
        if (binding.isArray()) {
            return this.containsNestedCapture(binding.getElementType(), true);
        }
        ITypeBinding[] typeArguments = binding.getTypeArguments();
        int i = 0;
        while (i < typeArguments.length) {
            if (this.containsNestedCapture(typeArguments[i], true)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsNestedCapture(String signature) {
        return signature.length() > 1 && signature.indexOf(33, 1) != -1;
    }

    private static ITypeBinding normalizeTypeBinding(ITypeBinding binding) {
        if (binding != null && !binding.isNullType() && !"void".equals(binding.getName())) {
            if (binding.isAnonymous()) {
                ITypeBinding[] baseBindings = binding.getInterfaces();
                if (baseBindings.length > 0) {
                    return baseBindings[0];
                }
                return binding.getSuperclass();
            }
            if (binding.isCapture()) {
                return binding.getWildcard();
            }
            return binding;
        }
        return null;
    }

    public Type addImport(ITypeBinding binding, AST ast) {
        return this.addImport(binding, ast, this.defaultContext, TypeLocation.UNKNOWN);
    }

    public Type addImport(ITypeBinding binding, AST ast, ImportRewriteContext context) {
        return this.addImport(binding, ast, context, TypeLocation.UNKNOWN);
    }

    public Type addImport(ITypeBinding binding, AST ast, ImportRewriteContext context, TypeLocation location) {
        ITypeBinding bindingPoint = this.checkAnnotationAndGenerics(binding);
        Type type = this.internalAddImport(bindingPoint == null ? binding : bindingPoint, ast, context, null, true, bindingPoint != null && !bindingPoint.equals(binding) ? TypeLocation.OTHER : location);
        if (bindingPoint != null && !bindingPoint.equals(binding)) {
            type = this.buildType(binding, bindingPoint, ast, context, type, location);
        }
        return type;
    }

    public String addImport(String qualifiedTypeName, ImportRewriteContext context) {
        int angleBracketOffset = qualifiedTypeName.indexOf(60);
        if (angleBracketOffset != -1) {
            return String.valueOf(this.internalAddImport(qualifiedTypeName.substring(0, angleBracketOffset), context, false)) + qualifiedTypeName.substring(angleBracketOffset);
        }
        int bracketOffset = qualifiedTypeName.indexOf(91);
        if (bracketOffset != -1) {
            return String.valueOf(this.internalAddImport(qualifiedTypeName.substring(0, bracketOffset), context, false)) + qualifiedTypeName.substring(bracketOffset);
        }
        return this.internalAddImport(qualifiedTypeName, context, false);
    }

    public String addImport(String qualifiedTypeName) {
        return this.addImport(qualifiedTypeName, this.defaultContext);
    }

    public String addStaticImport(IBinding binding) {
        return this.addStaticImport(binding, this.defaultContext);
    }

    public String addStaticImport(IBinding binding, ImportRewriteContext context) {
        if (Modifier.isStatic(binding.getModifiers())) {
            if (binding instanceof IVariableBinding) {
                IVariableBinding variableBinding = (IVariableBinding)binding;
                if (variableBinding.isField()) {
                    ITypeBinding declaringType = variableBinding.getDeclaringClass();
                    return this.addStaticImport(ImportRewrite.getRawQualifiedName(declaringType), binding.getName(), true, context);
                }
            } else if (binding instanceof IMethodBinding) {
                ITypeBinding declaringType = ((IMethodBinding)binding).getDeclaringClass();
                return this.addStaticImport(ImportRewrite.getRawQualifiedName(declaringType), binding.getName(), false, context);
            }
        }
        throw new IllegalArgumentException("Binding must be a static field or method.");
    }

    public String addStaticImport(String declaringTypeName, String simpleName, boolean isField) {
        return this.addStaticImport(declaringTypeName, simpleName, isField, this.defaultContext);
    }

    public String addStaticImport(String declaringTypeName, String simpleName, boolean isField, ImportRewriteContext context) {
        String key = String.valueOf(declaringTypeName) + '.' + simpleName;
        if (declaringTypeName.indexOf(46) == -1) {
            return key;
        }
        if (context == null) {
            context = this.defaultContext;
        }
        int kind = isField ? 2 : 3;
        this.importsKindMap.put(key, kind);
        int res = context.findInContext(declaringTypeName, simpleName, kind);
        if (res == 3) {
            return key;
        }
        if (res == 2) {
            this.addEntry(String.valueOf('s') + key);
        }
        if (res == 4) {
            this.addEntry(String.valueOf('s') + key);
            this.staticExplicitSimpleNames.add(simpleName);
        }
        return simpleName;
    }

    private String internalAddImport(String fullTypeName, ImportRewriteContext context, boolean isTypeInUnnamedPackage) {
        int res;
        String typeName;
        String typeContainerName;
        int idx = fullTypeName.lastIndexOf(46);
        if (idx != -1) {
            typeContainerName = fullTypeName.substring(0, idx);
            typeName = fullTypeName.substring(idx + 1);
        } else {
            typeContainerName = "";
            typeName = fullTypeName;
        }
        if (typeContainerName.length() == 0 && PrimitiveType.toCode(typeName) != null) {
            return fullTypeName;
        }
        if (context == null) {
            context = this.defaultContext;
        }
        if ((res = context.findInContext(typeContainerName, typeName, 1)) == 3 || isTypeInUnnamedPackage) {
            return fullTypeName;
        }
        if (res == 2) {
            this.addEntry(String.valueOf('n') + fullTypeName);
        }
        if (res == 4) {
            this.addEntry(String.valueOf('n') + fullTypeName);
            this.typeExplicitSimpleNames.add(typeName);
        }
        return typeName;
    }

    private void addEntry(String entry) {
        this.existingImports.add(entry);
        if (this.removedImports.remove(entry)) {
            return;
        }
        this.addedImports.add(entry);
    }

    private boolean removeEntry(String entry) {
        if (this.existingImports.remove(entry)) {
            if (this.addedImports.remove(entry)) {
                return true;
            }
            this.removedImports.add(entry);
            return true;
        }
        return false;
    }

    public boolean removeImport(String qualifiedName) {
        return this.removeEntry(String.valueOf('n') + qualifiedName);
    }

    public boolean removeStaticImport(String qualifiedName) {
        return this.removeEntry(String.valueOf('s') + qualifiedName);
    }

    private static String getRawName(ITypeBinding normalizedBinding) {
        return normalizedBinding.getTypeDeclaration().getName();
    }

    private static String getRawQualifiedName(ITypeBinding normalizedBinding) {
        return normalizedBinding.getTypeDeclaration().getQualifiedName();
    }

    public final TextEdit rewriteImports(IProgressMonitor monitor) throws CoreException {
        String qualifiedName;
        boolean isStatic;
        SubMonitor subMonitor = SubMonitor.convert(monitor, Messages.bind(Messages.importRewrite_processDescription), 2);
        if (!this.hasRecordedChanges()) {
            this.createdImports = CharOperation.NO_STRINGS;
            this.createdStaticImports = CharOperation.NO_STRINGS;
            return new MultiTextEdit();
        }
        CompilationUnit usedAstRoot = this.astRoot;
        if (usedAstRoot == null) {
            ASTParser parser = ASTParser.newParser(AST.getJLSLatest());
            parser.setSource(this.compilationUnit);
            parser.setFocalPosition(0);
            parser.setResolveBindings(false);
            usedAstRoot = (CompilationUnit)parser.createAST(subMonitor.split(1));
        }
        ImportRewriteConfiguration config = this.buildImportRewriteConfiguration();
        ImportRewriteAnalyzer computer = new ImportRewriteAnalyzer(this.compilationUnit, usedAstRoot, config);
        for (String addedImport : this.addedImports) {
            isStatic = 's' == addedImport.charAt(0);
            qualifiedName = addedImport.substring(1);
            computer.addImport(isStatic, qualifiedName);
        }
        for (String removedImport : this.removedImports) {
            isStatic = 's' == removedImport.charAt(0);
            qualifiedName = removedImport.substring(1);
            computer.removeImport(isStatic, qualifiedName);
        }
        for (String typeExplicitSimpleName : this.typeExplicitSimpleNames) {
            computer.requireExplicitImport(false, typeExplicitSimpleName);
        }
        for (String staticExplicitSimpleName : this.staticExplicitSimpleNames) {
            computer.requireExplicitImport(true, staticExplicitSimpleName);
        }
        ImportRewriteAnalyzer.RewriteResult result = computer.analyzeRewrite(subMonitor.split(1));
        this.createdImports = result.getCreatedImports();
        this.createdStaticImports = result.getCreatedStaticImports();
        return result.getTextEdit();
    }

    private ImportRewriteConfiguration buildImportRewriteConfiguration() {
        ImportRewriteConfiguration.Builder configBuilder = this.restoreExistingImports ? ImportRewriteConfiguration.Builder.preservingOriginalImports() : ImportRewriteConfiguration.Builder.discardingOriginalImports();
        configBuilder.setImportOrder(Arrays.asList(this.importOrder));
        configBuilder.setTypeOnDemandThreshold(this.importOnDemandThreshold);
        configBuilder.setStaticOnDemandThreshold(this.staticImportOnDemandThreshold);
        configBuilder.setTypeContainerSorting(this.useContextToFilterImplicitImports ? ImportRewriteConfiguration.ImportContainerSorting.BY_PACKAGE : ImportRewriteConfiguration.ImportContainerSorting.BY_PACKAGE_AND_CONTAINING_TYPE);
        configBuilder.setStaticContainerSorting(ImportRewriteConfiguration.ImportContainerSorting.BY_PACKAGE_AND_CONTAINING_TYPE);
        configBuilder.setImplicitImportIdentification(this.filterImplicitImports ? ImportRewriteConfiguration.ImplicitImportIdentification.JAVA_LANG_AND_CU_PACKAGE : ImportRewriteConfiguration.ImplicitImportIdentification.NONE);
        return configBuilder.build();
    }

    public String[] getCreatedImports() {
        return this.createdImports;
    }

    public String[] getCreatedStaticImports() {
        return this.createdStaticImports;
    }

    public String[] getAddedImports() {
        return ImportRewrite.filterFromList(this.addedImports, 'n');
    }

    public String[] getAddedStaticImports() {
        return ImportRewrite.filterFromList(this.addedImports, 's');
    }

    public String[] getRemovedImports() {
        return ImportRewrite.filterFromList(this.removedImports, 'n');
    }

    public String[] getRemovedStaticImports() {
        return ImportRewrite.filterFromList(this.removedImports, 's');
    }

    public boolean hasRecordedChanges() {
        return !this.restoreExistingImports || !this.addedImports.isEmpty() || !this.removedImports.isEmpty();
    }

    private static String[] filterFromList(List<String> imports, char prefix) {
        if (imports == null) {
            return CharOperation.NO_STRINGS;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String curr : imports) {
            if (prefix != curr.charAt(0)) continue;
            res.add(curr.substring(1));
        }
        return res.toArray(new String[res.size()]);
    }

    private void annotateList(List annotations, IAnnotationBinding[] annotationBindings, AST ast, ImportRewriteContext context, TypeLocation location, ITypeBinding type) {
        if (context == null) {
            context = this.defaultContext;
        }
        annotationBindings = context.removeRedundantTypeAnnotations(annotationBindings, location, type);
        int i = 0;
        while (i < annotationBindings.length) {
            Annotation annotation = this.addAnnotation(annotationBindings[i], ast, context);
            if (annotation != null) {
                annotations.add(annotation);
            }
            ++i;
        }
    }

    private Type annotateType(ITypeBinding binding, AST ast, ImportRewriteContext context, Type type, TypeLocation location) {
        IAnnotationBinding[] annotationBindings = binding.getTypeAnnotations();
        if (annotationBindings != null && annotationBindings.length > 0 && type instanceof AnnotatableType) {
            this.annotateList(((AnnotatableType)type).annotations(), annotationBindings, ast, context, location, binding);
        }
        return type;
    }

    private Type buildType(ITypeBinding binding, ITypeBinding bindingPoint, AST ast, ImportRewriteContext context, Type qualifier, TypeLocation location) {
        if (binding.equals(bindingPoint)) {
            return qualifier;
        }
        Type type = binding.isMember() ? this.buildType(binding.getDeclaringClass(), bindingPoint, ast, context, qualifier, TypeLocation.OTHER) : null;
        type = this.internalAddImport(binding, ast, context, type, false, location);
        return type;
    }

    private ITypeBinding checkAnnotationAndGenerics(ITypeBinding binding) {
        ITypeBinding bindingPoint = null;
        while (binding != null) {
            IAnnotationBinding[] annotationBinding = binding.getTypeAnnotations();
            ITypeBinding[] typeArguments = binding.getTypeArguments();
            if (annotationBinding != null && annotationBinding.length > 0 || typeArguments != null && typeArguments.length > 0) {
                bindingPoint = binding;
            }
            if (!binding.isMember()) break;
            binding = binding.getDeclaringClass();
        }
        return bindingPoint;
    }

    private Type createBaseType(AST ast, ImportRewriteContext context, ITypeBinding normalizedBinding, TypeLocation location) {
        AnnotatableType type;
        String res;
        IAnnotationBinding[] annotationBinding = normalizedBinding.getTypeAnnotations();
        boolean annotsPresent = annotationBinding != null && annotationBinding.length > 0;
        String qualifiedName = ImportRewrite.getRawQualifiedName(normalizedBinding);
        String string = res = qualifiedName.length() > 0 ? this.internalAddImport(qualifiedName, context, ImportRewrite.isTypeInUnnamedPackage(normalizedBinding)) : ImportRewrite.getRawName(normalizedBinding);
        if (annotsPresent) {
            int dotIndex;
            int n = dotIndex = res != null ? res.lastIndexOf(46) : -1;
            if (dotIndex > 0) {
                Name nameQualifier = ast.newName(res.substring(0, dotIndex));
                SimpleName simpleName = ast.newSimpleName(res.substring(dotIndex + 1));
                type = ast.newNameQualifiedType(nameQualifier, simpleName);
            } else {
                type = ast.newSimpleType(ast.newName(res));
            }
            this.annotateList(((AnnotatableType)type).annotations(), annotationBinding, ast, context, location, normalizedBinding);
        } else {
            type = ast.newSimpleType(ast.newName(res));
        }
        return type;
    }

    private Type getArrayType(Type elementType, AST ast, ImportRewriteContext context, ITypeBinding normalizedBinding, TypeLocation location) {
        int noDimensions = normalizedBinding.getDimensions();
        ArrayType arrayType = ast.newArrayType(elementType, noDimensions);
        if (ast.apiLevel() >= 8) {
            int i = 0;
            while (i < noDimensions) {
                IAnnotationBinding[] typeAnnotations = normalizedBinding.getTypeAnnotations();
                if (typeAnnotations.length > 0) {
                    Dimension dimension = (Dimension)arrayType.dimensions().get(i);
                    this.annotateList(dimension.annotations(), typeAnnotations, ast, context, i == 0 ? location : TypeLocation.ARRAY_CONTENTS, normalizedBinding);
                }
                normalizedBinding = normalizedBinding.getComponentType();
                ++i;
            }
        }
        return arrayType;
    }

    private Type internalAddImport(ITypeBinding binding, AST ast, ImportRewriteContext context, Type currentType, boolean getBase, TypeLocation location) {
        Type type = null;
        ITypeBinding normalizedBinding = null;
        if (binding.isPrimitive()) {
            type = ast.newPrimitiveType(PrimitiveType.toCode(binding.getName()));
            normalizedBinding = binding;
        } else {
            normalizedBinding = ImportRewrite.normalizeTypeBinding(binding);
            if (normalizedBinding == null) {
                return ast.newSimpleType(ast.newSimpleName("invalid"));
            }
            if (normalizedBinding.isTypeVariable()) {
                type = ast.newSimpleType(ast.newSimpleName(binding.getName()));
            } else if (normalizedBinding.isWildcardType()) {
                WildcardType wcType = ast.newWildcardType();
                ITypeBinding bound = normalizedBinding.getBound();
                if (bound != null && !bound.isWildcardType() && !bound.isCapture()) {
                    Type boundType = this.addImport(bound, ast, context, TypeLocation.TYPE_BOUND);
                    wcType.setBound(boundType, normalizedBinding.isUpperbound());
                }
                type = wcType;
            } else if (normalizedBinding.isArray()) {
                Type elementType = this.addImport(normalizedBinding.getElementType(), ast, context, TypeLocation.ARRAY_CONTENTS);
                type = this.getArrayType(elementType, ast, context, normalizedBinding, location);
            }
        }
        if (type != null) {
            return this.annotateType(normalizedBinding, ast, context, type, location);
        }
        if (getBase) {
            type = this.createBaseType(ast, context, normalizedBinding, location);
        } else {
            type = currentType != null ? ast.newQualifiedType(currentType, ast.newSimpleName(ImportRewrite.getRawName(normalizedBinding))) : ast.newSimpleType(ast.newName(ImportRewrite.getRawName(normalizedBinding)));
            type = this.annotateType(normalizedBinding, ast, context, type, location);
        }
        ITypeBinding[] typeArguments = normalizedBinding.getTypeArguments();
        if (typeArguments.length > 0) {
            ParameterizedType paramType = ast.newParameterizedType(type);
            List arguments = paramType.typeArguments();
            int i = 0;
            while (i < typeArguments.length) {
                ITypeBinding curr = typeArguments[i];
                if (this.containsNestedCapture(curr, false)) {
                    arguments.add(ast.newWildcardType());
                } else {
                    arguments.add(this.addImport(curr, ast, context, TypeLocation.TYPE_ARGUMENT));
                }
                ++i;
            }
            type = paramType;
        }
        return type;
    }

    private Expression addAnnotation(AST ast, Object value, ImportRewriteContext context) {
        if (value instanceof Boolean) {
            return ast.newBooleanLiteral((Boolean)value);
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return ast.newNumberLiteral(value.toString());
        }
        if (value instanceof Character) {
            CharacterLiteral result = ast.newCharacterLiteral();
            result.setCharValue(((Character)value).charValue());
            return result;
        }
        if (value instanceof ITypeBinding) {
            TypeLiteral result = ast.newTypeLiteral();
            result.setType(this.addImport((ITypeBinding)value, ast, context, TypeLocation.OTHER));
            return result;
        }
        if (value instanceof String) {
            StringLiteral result = ast.newStringLiteral();
            result.setLiteralValue((String)value);
            return result;
        }
        if (value instanceof IVariableBinding) {
            Name name;
            IVariableBinding variable = (IVariableBinding)value;
            FieldAccess result = ast.newFieldAccess();
            result.setName(ast.newSimpleName(variable.getName()));
            Type type = this.addImport(variable.getType(), ast, context, TypeLocation.OTHER);
            if (type instanceof SimpleType) {
                SimpleType simpleType = (SimpleType)type;
                name = simpleType.getName();
                simpleType.setName(ast.newSimpleName("a"));
            } else {
                name = ast.newName("invalid");
            }
            result.setExpression(name);
            return result;
        }
        if (value instanceof IAnnotationBinding) {
            return this.addAnnotation((IAnnotationBinding)value, ast, context);
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            if (values.length == 1) {
                return this.addAnnotation(ast, values[0], context);
            }
            ArrayInitializer initializer = ast.newArrayInitializer();
            List expressions = initializer.expressions();
            int size = values.length;
            int i = 0;
            while (i < size) {
                expressions.add(this.addAnnotation(ast, values[i], context));
                ++i;
            }
            return initializer;
        }
        return null;
    }

    private static boolean isTypeInUnnamedPackage(ITypeBinding binding) {
        IPackageBinding pBinding;
        boolean isInUnnamedPackage = false;
        if (binding != null && (pBinding = binding.getPackage()) != null) {
            isInUnnamedPackage = pBinding.isUnnamed();
        }
        return isInUnnamedPackage;
    }

    public static abstract class ImportRewriteContext {
        public static final int RES_NAME_FOUND = 1;
        public static final int RES_NAME_UNKNOWN = 2;
        public static final int RES_NAME_CONFLICT = 3;
        public static final int RES_NAME_UNKNOWN_NEEDS_EXPLICIT_IMPORT = 4;
        public static final int KIND_TYPE = 1;
        public static final int KIND_STATIC_FIELD = 2;
        public static final int KIND_STATIC_METHOD = 3;

        public abstract int findInContext(String var1, String var2, int var3);

        public IAnnotationBinding[] removeRedundantTypeAnnotations(IAnnotationBinding[] annotations, TypeLocation location, ITypeBinding type) {
            return annotations;
        }
    }

    public static enum TypeLocation {
        PARAMETER,
        RETURN_TYPE,
        FIELD,
        TYPE_PARAMETER,
        TYPE_BOUND,
        TYPE_ARGUMENT,
        ARRAY_CONTENTS,
        LOCAL_VARIABLE,
        CAST,
        INSTANCEOF,
        NEW,
        RECEIVER,
        EXCEPTION,
        OTHER,
        UNKNOWN;

    }
}

