/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.aspectj.asm.AsmManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Version;
import org.aspectj.tools.ajdoc.CompilerWrapper;
import org.aspectj.tools.ajdoc.Config;
import org.aspectj.tools.ajdoc.DocException;
import org.aspectj.tools.ajdoc.HtmlDecorator;
import org.aspectj.tools.ajdoc.JavadocRunner;
import org.aspectj.tools.ajdoc.StructureUtil;
import org.aspectj.tools.ajdoc.StubFileGenerator;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;

public class Main
implements Config {
    private static final String FAIL_MESSAGE = "> compile failed, exiting ajdoc";
    static Vector<String> options;
    static Vector<String> ajcOptions;
    static Vector<String> filenames;
    static Vector<String> fileList;
    static Vector<String> packageList;
    static String docModifier;
    static Vector<String> sourcepath;
    static boolean verboseMode;
    static boolean packageMode;
    static boolean authorStandardDocletSwitch;
    static boolean versionStandardDocletSwitch;
    static File rootDir;
    static Hashtable declIDTable;
    static String docDir;
    private static boolean deleteTempFilesOnExit;
    private static boolean aborted;
    private static IMessage[] errors;
    private static boolean shownAjdocUsageMessage;
    private static String outputWorkingDir;
    static final String internalErrorMessage = "                                                                  \nIf this has not already been logged as a bug raised please raise  \na new AspectJ bug at https://github.com/eclipse/org.aspectj/issues \nincluding the text below. To make the bug a priority, please also \ninclude a test program that can reproduce this problem.\n ";

    public static void clearState() {
        options = new Vector();
        ajcOptions = new Vector();
        filenames = new Vector();
        fileList = new Vector();
        packageList = new Vector();
        docModifier = "package";
        sourcepath = new Vector();
        verboseMode = false;
        packageMode = false;
        rootDir = null;
        declIDTable = new Hashtable();
        docDir = ".";
        aborted = false;
        deleteTempFilesOnExit = true;
    }

    public static void main(String[] args) {
        Main.clearState();
        sourcepath.addElement(".");
        Main.parseCommandLine(args);
        rootDir = Main.getRootDir();
        File[] inputFiles = new File[filenames.size()];
        File[] signatureFiles = new File[filenames.size()];
        try {
            if (!new File(outputWorkingDir).isDirectory()) {
                File dir = new File(outputWorkingDir);
                dir.mkdir();
                if (deleteTempFilesOnExit) {
                    dir.deleteOnExit();
                }
            }
            for (int i = 0; i < filenames.size(); ++i) {
                inputFiles[i] = new File(filenames.elementAt(i));
            }
            AsmManager model = Main.callAjc(inputFiles);
            if (CompilerWrapper.hasErrors()) {
                System.out.println(FAIL_MESSAGE);
                aborted = true;
                errors = CompilerWrapper.getErrors();
                return;
            }
            for (int ii = 0; ii < filenames.size(); ++ii) {
                signatureFiles[ii] = Main.createSignatureFile(model, inputFiles[ii]);
            }
            System.out.println("> Building signature files...");
            try {
                StubFileGenerator.doFiles(model, declIDTable, inputFiles, signatureFiles);
                Main.packageHTML(model, inputFiles);
            }
            catch (DocException d) {
                System.err.println(d.getMessage());
                return;
            }
            Main.callJavadoc(signatureFiles);
            Main.decorateHtmlFiles(model, inputFiles);
            System.out.println("> Finished.");
        }
        catch (Throwable e) {
            Main.handleInternalError(e);
            Main.exit(-2);
        }
    }

    private static void packageHTML(AsmManager model, File[] inputFiles) throws IOException {
        ArrayList<String> dirList = new ArrayList<String>();
        for (File inputFile : inputFiles) {
            String packageName = StructureUtil.getPackageDeclarationFromFile(model, inputFile);
            if (dirList.contains(packageName)) continue;
            String dir = inputFile.getAbsolutePath().substring(0, inputFile.getAbsolutePath().lastIndexOf(File.separator));
            File input = new File(dir + "/" + "package.html");
            File inDir = new File(dir + "/" + "doc-files");
            if (!input.exists()) {
                dirList.add(packageName);
                continue;
            }
            String filename = "";
            String docFiles = "";
            if (packageName != null) {
                String pathName = outputWorkingDir + File.separator + packageName.replace('.', File.separatorChar);
                File packageDir = new File(pathName);
                if (!packageDir.exists()) {
                    dirList.add(packageName);
                    continue;
                }
                packageName = packageName.replace('.', '/');
                filename = outputWorkingDir + "/" + packageName + "/" + "package.html";
                docFiles = rootDir.getAbsolutePath() + "/" + packageName + "/" + "doc-files";
            } else {
                filename = outputWorkingDir + "/" + "package.html";
                docFiles = rootDir.getAbsolutePath() + "/" + "doc-files";
            }
            File output = new File(filename);
            FileUtil.copyFile(input, output);
            if (!inDir.exists()) continue;
            File outDir = new File(docFiles);
            System.out.println("> Copying folder " + outDir);
            FileUtil.copyFile(inDir, outDir);
        }
    }

    private static AsmManager callAjc(File[] inputFiles) {
        int i;
        ajcOptions.addElement("-noExit");
        ajcOptions.addElement("-XjavadocsInModel");
        ajcOptions.addElement("-d");
        ajcOptions.addElement(rootDir.getAbsolutePath());
        String[] argsToCompiler = new String[ajcOptions.size() + inputFiles.length];
        for (i = 0; i < ajcOptions.size(); ++i) {
            argsToCompiler[i] = ajcOptions.elementAt(i);
        }
        for (File inputFile : inputFiles) {
            argsToCompiler[i] = inputFile.getAbsolutePath();
            ++i;
        }
        System.out.println("> Calling ajc...");
        return CompilerWrapper.executeMain(argsToCompiler);
    }

    private static void callJavadoc(File[] signatureFiles) throws IOException {
        System.out.println("> Calling javadoc...");
        String[] javadocargs = null;
        ArrayList<String> files = new ArrayList<String>();
        if (packageMode) {
            int k;
            int numExtraArgs = 2;
            if (authorStandardDocletSwitch) {
                ++numExtraArgs;
            }
            if (versionStandardDocletSwitch) {
                ++numExtraArgs;
            }
            javadocargs = new String[numExtraArgs + options.size() + packageList.size() + fileList.size()];
            javadocargs[0] = "-sourcepath";
            javadocargs[1] = outputWorkingDir;
            int argIndex = 2;
            if (authorStandardDocletSwitch) {
                javadocargs[argIndex] = "-author";
                ++argIndex;
            }
            if (versionStandardDocletSwitch) {
                javadocargs[argIndex] = "-version";
            }
            for (k = 0; k < options.size(); ++k) {
                javadocargs[numExtraArgs + k] = options.elementAt(k);
            }
            for (k = 0; k < packageList.size(); ++k) {
                javadocargs[numExtraArgs + Main.options.size() + k] = packageList.elementAt(k);
            }
            for (k = 0; k < fileList.size(); ++k) {
                javadocargs[numExtraArgs + Main.options.size() + Main.packageList.size() + k] = fileList.elementAt(k);
            }
            if (LangUtil.is9VMOrGreater()) {
                options = new Vector();
                Collections.addAll(options, javadocargs);
            }
        } else {
            int k;
            javadocargs = new String[options.size() + signatureFiles.length];
            for (k = 0; k < options.size(); ++k) {
                javadocargs[k] = options.elementAt(k);
            }
            for (k = 0; k < signatureFiles.length; ++k) {
                javadocargs[Main.options.size() + k] = StructureUtil.translateAjPathName(signatureFiles[k].getCanonicalPath());
            }
            for (File signatureFile : signatureFiles) {
                files.add(StructureUtil.translateAjPathName(signatureFile.getCanonicalPath()));
            }
        }
        if (LangUtil.is9VMOrGreater()) {
            JavadocRunner.callJavadocViaToolProvider(options, files);
        } else {
            JavadocRunner.callJavadoc(javadocargs);
        }
    }

    private static void decorateHtmlFiles(AsmManager model, File[] inputFiles) throws IOException {
        System.out.println("> Decorating html files...");
        HtmlDecorator.decorateHTMLFromInputFiles(model, declIDTable, rootDir, inputFiles, docModifier);
        System.out.println("> Removing generated tags...");
        Main.removeDeclIDsFromFile("index-all.html", true);
        Main.removeDeclIDsFromFile("serialized-form.html", true);
        if (packageList.size() > 0) {
            for (int p = 0; p < packageList.size(); ++p) {
                Main.removeDeclIDsFromFile(packageList.elementAt(p).replace('.', '/') + "/" + "package-summary.html", true);
            }
        } else {
            File[] files = rootDir.listFiles();
            if (files == null) {
                System.err.println("Destination directory is not a directory: " + rootDir.toString());
                return;
            }
            for (File file : files = FileUtil.listFiles(rootDir, new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().equals("package-summary.html");
                }
            })) {
                Main.removeDeclIDsFromFile(file.getAbsolutePath(), false);
            }
        }
    }

    private static void removeDeclIDsFromFile(String filename, boolean relativePath) {
        File indexFile = relativePath ? new File(docDir + "/" + filename) : new File(filename);
        try {
            if (indexFile.exists()) {
                BufferedReader indexFileReader = new BufferedReader(new FileReader(indexFile));
                StringBuilder indexFileBuffer = new StringBuilder((int)indexFile.length());
                String line = indexFileReader.readLine();
                while (line != null) {
                    int indexStart = line.indexOf("__AJDECLID:");
                    int indexEnd = line.indexOf(":__");
                    if (indexStart != -1 && indexEnd != -1) {
                        line = line.substring(0, indexStart) + line.substring(indexEnd + ":__".length());
                    }
                    indexFileBuffer.append(line);
                    line = indexFileReader.readLine();
                }
                FileOutputStream fos = new FileOutputStream(indexFile);
                fos.write(indexFileBuffer.toString().getBytes());
                indexFileReader.close();
                fos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static Vector<String> getSourcePath() {
        Vector<String> sourcePath = new Vector<String>();
        boolean found = false;
        for (int i = 0; i < options.size(); ++i) {
            String currOption = options.elementAt(i);
            if (found && !currOption.startsWith("-")) {
                sourcePath.add(currOption);
            }
            if (!currOption.equals("-sourcepath")) continue;
            found = true;
        }
        return sourcePath;
    }

    static File getRootDir() {
        File rootDir = new File(".");
        for (int i = 0; i < options.size(); ++i) {
            if (!options.elementAt(i).equals("-d") || (rootDir = new File(options.elementAt(i + 1))).exists()) continue;
            rootDir.mkdir();
        }
        return rootDir;
    }

    static File createSignatureFile(AsmManager model, File inputFile) throws IOException {
        String packageName = StructureUtil.getPackageDeclarationFromFile(model, inputFile);
        String filename = "";
        if (packageName != null) {
            String pathName = outputWorkingDir + '/' + packageName.replace('.', '/');
            File packageDir = new File(pathName);
            if (!packageDir.exists()) {
                packageDir.mkdirs();
                if (deleteTempFilesOnExit) {
                    packageDir.deleteOnExit();
                }
            }
            packageName = packageName.replace('.', '/');
            filename = outputWorkingDir + "/" + packageName + "/" + inputFile.getName();
        } else {
            filename = outputWorkingDir + "/" + inputFile.getName();
        }
        File signatureFile = new File(filename);
        if (deleteTempFilesOnExit) {
            signatureFile.deleteOnExit();
        }
        return signatureFile;
    }

    static void parseCommandLine(String[] args) {
        if (args.length == 0) {
            Main.displayHelpAndExit(null);
        } else if (args.length == 1 && args[0].startsWith("@")) {
            String argFile = args[0].substring(1);
            System.out.println("> Using arg file: " + argFile);
            try {
                BufferedReader br = new BufferedReader(new FileReader(argFile));
                String line = "";
                line = br.readLine();
                StringTokenizer st = new StringTokenizer(line, " ");
                ArrayList<String> argList = new ArrayList<String>();
                while (st.hasMoreElements()) {
                    argList.add(st.nextToken());
                }
                args = new String[argList.size()];
                int counter = 0;
                Iterator iterator = argList.iterator();
                while (iterator.hasNext()) {
                    String s;
                    args[counter] = s = (String)iterator.next();
                    ++counter;
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("> could not read arg file: " + argFile);
                e.printStackTrace();
            }
            catch (IOException ioe) {
                System.err.println("> could not read arg file: " + argFile);
                ioe.printStackTrace();
            }
        }
        LinkedList<String> vargs = new LinkedList<String>(Arrays.asList(args));
        vargs.add("-Xset:minimalModel=false");
        Main.parseArgs(vargs, new File("."));
        if (filenames.size() == 0) {
            Main.displayHelpAndExit("ajdoc: No packages or classes specified");
        }
    }

    static void setSourcepath(String arg) {
        sourcepath.clear();
        arg = arg + File.pathSeparator;
        StringTokenizer tokenizer = new StringTokenizer(arg, File.pathSeparator);
        while (tokenizer.hasMoreElements()) {
            sourcepath.addElement(tokenizer.nextToken());
        }
    }

    static String getSourcepathAsString() {
        String cPath = "";
        for (int i = 0; i < sourcepath.size(); ++i) {
            cPath = cPath + sourcepath.elementAt(i) + "/" + outputWorkingDir;
            if (i == sourcepath.size() - 1) continue;
            cPath = cPath + File.pathSeparator;
        }
        return cPath;
    }

    static void parseArgs(List vargs, File currentWorkingDir) {
        boolean addNextAsOption = false;
        boolean addNextAsArgFile = false;
        boolean addNextToAJCOptions = false;
        boolean addNextAsDocDir = false;
        boolean addNextAsClasspath = false;
        boolean ignoreArg = false;
        boolean addNextAsSourcePath = false;
        if (vargs.size() == 0) {
            Main.displayHelpAndExit(null);
        }
        for (Object varg : vargs) {
            String arg = (String)varg;
            ignoreArg = false;
            if (addNextAsDocDir) {
                docDir = arg;
                addNextAsDocDir = false;
            }
            if (addNextAsClasspath) {
                addNextAsClasspath = false;
            }
            if (addNextAsSourcePath) {
                Main.setSourcepath(arg);
                addNextAsSourcePath = false;
                ignoreArg = true;
            }
            if (arg.startsWith("@")) {
                Main.expandAtSignFile(arg.substring(1), currentWorkingDir);
                continue;
            }
            if (arg.equals("-argfile")) {
                addNextAsArgFile = true;
                continue;
            }
            if (addNextAsArgFile) {
                Main.expandAtSignFile(arg, currentWorkingDir);
                addNextAsArgFile = false;
                continue;
            }
            if (arg.equals("-d")) {
                addNextAsOption = true;
                options.addElement(arg);
                addNextAsDocDir = true;
                continue;
            }
            if (arg.equals("-bootclasspath")) {
                addNextAsOption = true;
                addNextToAJCOptions = true;
                options.addElement(arg);
                ajcOptions.addElement(arg);
                continue;
            }
            if (arg.equals("-source")) {
                addNextAsOption = true;
                addNextToAJCOptions = true;
                addNextAsClasspath = true;
                options.addElement(arg);
                ajcOptions.addElement(arg);
                continue;
            }
            if (arg.equals("-classpath")) {
                addNextAsOption = true;
                addNextToAJCOptions = true;
                addNextAsClasspath = true;
                options.addElement(arg);
                ajcOptions.addElement(arg);
                continue;
            }
            if (arg.equals("-encoding")) {
                addNextAsOption = true;
                addNextToAJCOptions = false;
                options.addElement(arg);
                continue;
            }
            if (arg.equals("-docencoding")) {
                addNextAsOption = true;
                addNextToAJCOptions = false;
                options.addElement(arg);
                continue;
            }
            if (arg.equals("-charset")) {
                addNextAsOption = true;
                addNextToAJCOptions = false;
                options.addElement(arg);
                continue;
            }
            if (arg.equals("-sourcepath")) {
                addNextAsSourcePath = true;
                continue;
            }
            if (arg.equals("-link")) {
                addNextAsOption = true;
                options.addElement(arg);
                continue;
            }
            if (arg.equals("-bottom")) {
                addNextAsOption = true;
                options.addElement(arg);
                continue;
            }
            if (arg.equals("-windowtitle")) {
                addNextAsOption = true;
                options.addElement(arg);
                continue;
            }
            if (arg.equals("-XajdocDebug")) {
                deleteTempFilesOnExit = false;
                continue;
            }
            if (arg.equals("-use")) {
                System.out.println("> Ignoring unsupported option: -use");
                continue;
            }
            if (arg.equals("-splitindex")) continue;
            if (arg.startsWith("-") || addNextAsOption || addNextToAJCOptions) {
                if (arg.equals("-private")) {
                    docModifier = "private";
                } else if (arg.equals("-package")) {
                    docModifier = "package";
                } else if (arg.equals("-protected")) {
                    docModifier = "protected";
                } else if (arg.equals("-public")) {
                    docModifier = "public";
                } else if (arg.equals("-verbose")) {
                    verboseMode = true;
                } else if (arg.equals("-author")) {
                    authorStandardDocletSwitch = true;
                } else if (arg.equals("-version")) {
                    versionStandardDocletSwitch = true;
                } else if (arg.equals("-v")) {
                    System.out.println(Main.getVersion());
                    Main.exit(0);
                } else if (arg.equals("-help")) {
                    Main.displayHelpAndExit(null);
                } else if (arg.equals("-doclet") || arg.equals("-docletpath")) {
                    System.out.println("The doclet and docletpath options are not currently supported    \nsince ajdoc makes assumptions about the behavior of the standard \ndoclet. If you would find this option useful please email us at: \n                                                                 \n       aspectj-dev@eclipse.org                            \n                                                                 \n");
                    Main.exit(0);
                } else if (!arg.equals("-nonavbar") && !arg.equals("-noindex")) {
                    if (addNextToAJCOptions || addNextAsOption) {
                        if (addNextToAJCOptions) {
                            ajcOptions.addElement(arg);
                            if (!arg.startsWith("-")) {
                                addNextToAJCOptions = false;
                            }
                            if (!addNextAsOption) {
                                continue;
                            }
                        }
                    } else {
                        if (arg.startsWith("-")) {
                            ajcOptions.addElement(arg);
                            addNextToAJCOptions = true;
                            continue;
                        }
                        System.err.println("> unrecognized argument: " + arg);
                        Main.displayHelpAndExit(null);
                    }
                }
                options.addElement(arg);
                addNextAsOption = false;
                continue;
            }
            if (FileUtil.hasSourceSuffix(arg) || arg.endsWith(".lst") && arg != null) {
                File f = new File(arg);
                if (f.isAbsolute()) {
                    filenames.addElement(arg);
                } else {
                    filenames.addElement(currentWorkingDir + "/" + arg);
                }
                fileList.addElement(arg);
                continue;
            }
            if (ignoreArg) continue;
            packageMode = true;
            packageList.addElement(arg);
            arg = arg.replace('.', '/');
            for (int c = 0; c < sourcepath.size(); ++c) {
                String path = sourcepath.elementAt(c) + "/" + arg;
                File pkg = new File(path);
                if (pkg.isDirectory()) {
                    String[] files;
                    for (String file : files = pkg.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            int index1 = name.lastIndexOf(".");
                            int index2 = name.length();
                            return index1 >= 0 && index2 >= 0 && (name.substring(index1, index2).equals(".java") || name.substring(index1, index2).equals(".aj"));
                        }
                    })) {
                        filenames.addElement(sourcepath.elementAt(c) + "/" + arg + "/" + file);
                    }
                    continue;
                }
                if (c != sourcepath.size()) continue;
                System.out.println("ajdoc: No package, class, or source file found named " + arg + ".");
            }
        }
        if (!(options.contains("-private") || options.contains("-package") || options.contains("-protected") || options.contains("-public"))) {
            options.addElement("-package");
        }
    }

    static void expandAtSignFile(String filename, File currentWorkingDir) {
        LinkedList<String> result = new LinkedList<String>();
        File atFile = Main.qualifiedFile(filename, currentWorkingDir);
        String atFileParent = atFile.getParent();
        File myWorkingDir = null;
        if (atFileParent != null) {
            myWorkingDir = new File(atFileParent);
        }
        try {
            BufferedReader stream = new BufferedReader(new FileReader(atFile));
            String line = null;
            while ((line = stream.readLine()) != null) {
                int commentStart = line.indexOf("//");
                if (commentStart != -1) {
                    line = line.substring(0, commentStart);
                }
                if ((line = line.trim()).length() == 0) continue;
                result.add(line);
            }
            stream.close();
        }
        catch (IOException e) {
            System.err.println("Error while reading the @ file " + atFile.getPath() + ".\n" + e);
            System.exit(-1);
        }
        Main.parseArgs(result, myWorkingDir);
    }

    static File qualifiedFile(String name, File currentWorkingDir) {
        File file = new File(name = name.replace('/', File.separatorChar));
        if (!file.isAbsolute() && currentWorkingDir != null) {
            file = new File(currentWorkingDir, name);
        }
        return file;
    }

    static void displayHelpAndExit(String message) {
        shownAjdocUsageMessage = true;
        if (message != null) {
            System.err.println(message);
            System.err.println();
            System.err.println("Usage: ajdoc <options> <source files>\n\nwhere <options> includes:\n  -public                   Show only public classes and members\n  -protected                Show protected/public classes and members\n  -package                  Show package/protected/public classes and members\n  -private                  Show all classes and members\n  -help                     Display command line options\n  -sourcepath <pathlist>    Specify where to find source files\n  -classpath <pathlist>     Specify where to find user class files\n  -bootclasspath <pathlist> Override location of class files loaded\n  -d <directory>            Destination directory for output files\n  -windowtitle <text>       Browser window title for the documenation  -bottom <html-code>       Include bottom text for each page  -link <url>               Create links to javadoc output at <url>  -argfile <file>           Build config file (wildcards not supported)\n  -verbose                  Output messages about what Javadoc is doing\n  -v                        Print out the version of ajdoc\n  -source <version>         set source level (1.3, 1.4 or 1.5)\n\nas well as the AspectJ Compiler options.\n\nIf an argument is of the form @<filename>, the file will be interpreted as\na line delimited set of arguments to insert into the argument list.\n");
        } else {
            System.out.println("Usage: ajdoc <options> <source files>\n\nwhere <options> includes:\n  -public                   Show only public classes and members\n  -protected                Show protected/public classes and members\n  -package                  Show package/protected/public classes and members\n  -private                  Show all classes and members\n  -help                     Display command line options\n  -sourcepath <pathlist>    Specify where to find source files\n  -classpath <pathlist>     Specify where to find user class files\n  -bootclasspath <pathlist> Override location of class files loaded\n  -d <directory>            Destination directory for output files\n  -windowtitle <text>       Browser window title for the documenation  -bottom <html-code>       Include bottom text for each page  -link <url>               Create links to javadoc output at <url>  -argfile <file>           Build config file (wildcards not supported)\n  -verbose                  Output messages about what Javadoc is doing\n  -v                        Print out the version of ajdoc\n  -source <version>         set source level (1.3, 1.4 or 1.5)\n\nas well as the AspectJ Compiler options.\n\nIf an argument is of the form @<filename>, the file will be interpreted as\na line delimited set of arguments to insert into the argument list.\n");
            Main.exit(0);
        }
    }

    protected static void exit(int value) {
        System.out.flush();
        System.err.flush();
        System.exit(value);
    }

    public static void handleInternalError(Throwable uncaughtThrowable) {
        System.err.println("An internal error occured in ajdoc");
        System.err.println(internalErrorMessage);
        System.err.println(uncaughtThrowable.toString());
        uncaughtThrowable.printStackTrace();
        System.err.println();
    }

    static String getVersion() {
        return "ajdoc version " + Version.getText();
    }

    public static boolean hasAborted() {
        return aborted;
    }

    public static IMessage[] getErrors() {
        return errors;
    }

    public static boolean hasShownAjdocUsageMessage() {
        return shownAjdocUsageMessage;
    }

    public static void setOutputWorkingDir(String fullyQulifiedOutputDir) {
        if (fullyQulifiedOutputDir == null) {
            Main.resetOutputWorkingDir();
        } else {
            outputWorkingDir = fullyQulifiedOutputDir + File.separatorChar + "ajdocworkingdir";
        }
    }

    public static void resetOutputWorkingDir() {
        outputWorkingDir = "ajdocworkingdir";
    }

    static {
        docModifier = "package";
        verboseMode = false;
        packageMode = false;
        authorStandardDocletSwitch = false;
        versionStandardDocletSwitch = false;
        rootDir = null;
        declIDTable = new Hashtable();
        docDir = ".";
        deleteTempFilesOnExit = true;
        aborted = false;
        shownAjdocUsageMessage = false;
        outputWorkingDir = "ajdocworkingdir";
    }
}

