/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Scanner;
import org.bytedeco.javacpp.tools.Context;
import org.bytedeco.javacpp.tools.Declaration;
import org.bytedeco.javacpp.tools.Declarator;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.TemplateMap;
import org.bytedeco.javacpp.tools.Type;

class DeclarationList
extends LinkedList<Declaration> {
    InfoMap infoMap = null;
    Context context = null;
    TemplateMap templateMap = null;
    ListIterator<Info> infoIterator = null;
    String spacing = null;

    DeclarationList() {
    }

    String rescan(String lines) {
        if (this.spacing == null) {
            return lines;
        }
        String text = "";
        Scanner scanner = new Scanner(lines);
        while (scanner.hasNextLine()) {
            text = text + this.spacing + scanner.nextLine();
            int newline = this.spacing.lastIndexOf(10);
            this.spacing = newline >= 0 ? this.spacing.substring(newline) : "\n";
        }
        return text;
    }

    @Override
    public boolean add(Declaration decl) {
        boolean add = true;
        if (!(this.templateMap == null || this.templateMap.full() || decl.type == null && decl.declarator == null)) {
            Type type = this.templateMap.type = decl.type;
            this.templateMap.declarator = decl.declarator;
            Declarator dcl = this.templateMap.declarator;
            LinkedList<Info> infoList = this.infoMap.get(dcl != null ? dcl.cppName : type.cppName);
            this.infoIterator = infoList.size() > 0 ? infoList.listIterator() : null;
            add = false;
        } else if (decl.declarator != null && decl.declarator.type != null) {
            Info info = this.infoMap.getFirst(decl.declarator.type.cppName);
            if (info != null && info.skip && info.valueTypes == null && info.pointerTypes == null) {
                add = false;
            } else if (decl.declarator.parameters != null) {
                for (Declarator d : decl.declarator.parameters.declarators) {
                    if (d == null || d.type == null || (info = this.infoMap.getFirst(d.type.cppName)) == null || !info.skip || info.valueTypes != null || info.pointerTypes != null) continue;
                    add = false;
                    break;
                }
            }
        }
        if (!add) {
            return false;
        }
        LinkedList stack = new LinkedList();
        ListIterator<Declaration> it = stack.listIterator();
        it.add(decl);
        it.previous();
        while (it.hasNext()) {
            decl = (Declaration)it.next();
            Declarator dcl = decl.declarator;
            if (dcl != null && dcl.definition != null) {
                it.add(dcl.definition);
                it.previous();
            }
            if (dcl == null || dcl.parameters == null || dcl.parameters.declarators == null) continue;
            for (Declarator d : dcl.parameters.declarators) {
                if (d == null || d.definition == null) continue;
                it.add(d.definition);
                it.previous();
            }
        }
        while (!stack.isEmpty()) {
            decl = (Declaration)stack.removeLast();
            if (this.context != null) {
                decl.inaccessible = this.context.inaccessible;
            }
            if (decl.text.length() == 0) {
                decl.inaccessible = true;
            }
            it = this.listIterator();
            boolean found = false;
            while (it.hasNext()) {
                Declaration d = (Declaration)it.next();
                if (d.signature.length() <= 0 || !d.signature.equals(decl.signature)) continue;
                if (d.constMember && !decl.constMember || d.inaccessible && !decl.inaccessible || d.incomplete && !decl.incomplete) {
                    it.remove();
                    continue;
                }
                found = true;
            }
            if (found) continue;
            decl.text = this.rescan(decl.text);
            super.add(decl);
        }
        return true;
    }
}

