/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.filter;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class LogicalExprFilter
extends ColumnFilter {
    protected LogicalExprType logicalOperator = LogicalExprType.AND;
    protected List<ColumnFilter> logicalTerms = new ArrayList<ColumnFilter>();

    public LogicalExprFilter() {
    }

    public LogicalExprFilter(String columnId, LogicalExprType operator, List<ColumnFilter> terms) {
        super(columnId);
        this.logicalOperator = operator;
        this.setLogicalTerms(terms);
        this.setColumnId(columnId);
    }

    public LogicalExprFilter(String columnId, LogicalExprType operator, ColumnFilter ... terms) {
        super(columnId);
        this.logicalOperator = operator;
        this.setLogicalTerms(terms);
        this.setColumnId(columnId);
    }

    @Override
    public void setColumnId(String columnId) {
        String oldColumnId = this.getColumnId();
        super.setColumnId(columnId);
        for (ColumnFilter childFunction : this.logicalTerms) {
            String childColumnId = childFunction.getColumnId();
            if (childColumnId != null && !childColumnId.equals(oldColumnId)) continue;
            childFunction.setColumnId(columnId);
        }
    }

    public LogicalExprType getLogicalOperator() {
        return this.logicalOperator;
    }

    public void setLogicalOperator(LogicalExprType logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public List<ColumnFilter> getLogicalTerms() {
        return this.logicalTerms;
    }

    public void setLogicalTerms(List<ColumnFilter> logicalTerms) {
        this.logicalTerms = logicalTerms;
    }

    public void addLogicalTerm(ColumnFilter logicalTerm) {
        String childColumnId = logicalTerm.getColumnId();
        if (childColumnId == null) {
            logicalTerm.setColumnId(this.getColumnId());
        }
        this.logicalTerms.add(logicalTerm);
    }

    public void setLogicalTerms(ColumnFilter ... logicalTerms) {
        this.logicalTerms.clear();
        for (ColumnFilter term : logicalTerms) {
            this.addLogicalTerm(term);
        }
    }

    @Override
    public ColumnFilter cloneInstance() {
        LogicalExprFilter clone = new LogicalExprFilter();
        clone.columnId = this.columnId;
        clone.logicalOperator = this.logicalOperator;
        for (ColumnFilter term : this.logicalTerms) {
            clone.logicalTerms.add(term.cloneInstance());
        }
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            LogicalExprFilter other = (LogicalExprFilter)obj;
            if (!super.equals(other)) {
                return false;
            }
            if (this.logicalOperator != null && !this.logicalOperator.equals((Object)other.logicalOperator)) {
                return false;
            }
            if (this.logicalTerms.size() != other.logicalTerms.size()) {
                return false;
            }
            for (ColumnFilter fc : this.logicalTerms) {
                if (other.logicalTerms.contains(fc)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("(");
        for (int i = 0; i < this.logicalTerms.size(); ++i) {
            if (i > 0) {
                out.append(" ").append((Object)this.logicalOperator).append(" ");
            }
            out.append(this.logicalTerms.get(i).toString());
        }
        out.append(")");
        return out.toString();
    }
}

