/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.impl;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.impl.DataSetImpl;

public class DataSetMetadataImpl
implements DataSetMetadata {
    protected DataSetDef definition;
    protected String uuid;
    protected int numberOfRows;
    protected int numberOfColumns;
    protected List<String> columnIds = new ArrayList<String>();
    protected List<ColumnType> columnTypes = new ArrayList<ColumnType>();
    protected int estimatedSize;

    public DataSetMetadataImpl() {
    }

    public DataSetMetadataImpl(DataSetDef definition, String uuid, int numberOfRows, int numberOfColumns, List<String> columnIds, List<ColumnType> columnTypes, int estimatedSize) {
        this.definition = definition;
        this.uuid = uuid;
        this.numberOfRows = numberOfRows;
        this.numberOfColumns = numberOfColumns;
        this.columnIds = columnIds;
        this.columnTypes = columnTypes;
        this.estimatedSize = estimatedSize;
    }

    public DataSetMetadataImpl(DataSetImpl dataSet) {
        this.definition = dataSet.getDefinition();
        this.uuid = dataSet.uuid;
        this.numberOfRows = dataSet.getRowCount();
        this.estimatedSize = (int)dataSet.getEstimatedSize();
        this.numberOfColumns = dataSet.getColumns().size();
        for (DataColumn column : dataSet.getColumns()) {
            this.columnIds.add(column.getId());
            this.columnTypes.add(column.getColumnType());
        }
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    @Override
    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public String getColumnId(int columnIndex) {
        return this.columnIds.get(columnIndex);
    }

    @Override
    public ColumnType getColumnType(int columnIndex) {
        return this.columnTypes.get(columnIndex);
    }

    @Override
    public ColumnType getColumnType(String columnId) {
        if (columnId == null) {
            return null;
        }
        for (int i = 0; i < this.columnIds.size(); ++i) {
            if (!columnId.equalsIgnoreCase(this.columnIds.get(i))) continue;
            return this.columnTypes.get(i);
        }
        return null;
    }

    @Override
    public List<String> getColumnIds() {
        return this.columnIds;
    }

    @Override
    public List<ColumnType> getColumnTypes() {
        return this.columnTypes;
    }

    @Override
    public DataSetDef getDefinition() {
        return this.definition;
    }

    public void setDefinition(DataSetDef definition) {
        this.definition = definition;
    }

    public boolean equals(Object obj) {
        try {
            int i;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            DataSetMetadataImpl other = (DataSetMetadataImpl)obj;
            if (this.numberOfColumns != other.numberOfColumns) {
                return false;
            }
            if (this.numberOfRows != other.numberOfRows) {
                return false;
            }
            if (this.estimatedSize != other.estimatedSize) {
                return false;
            }
            for (i = 0; i < this.columnIds.size(); ++i) {
                if (this.columnIds.get(i).equalsIgnoreCase(other.columnIds.get(i))) continue;
                return false;
            }
            for (i = 0; i < this.columnTypes.size(); ++i) {
                if (this.columnTypes.get(i).equals((Object)other.columnTypes.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

